/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.additional;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.base.renderers.MarkerRenderer;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.DataLabels;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.Yaxes;
import org.dussan.vaadin.dcharts.metadata.locations.LegendLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.metadata.styles.MarkerStyles;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.AxesDefaults;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.axis.LinearAxisRenderer;
import org.dussan.vaadin.dcharts.renderers.series.DonutRenderer;

import com.vaadin.ui.TabSheet;

public class ChartsPlacedInTabs extends ChartContext {

	private static final long serialVersionUID = -1860938239126216064L;

	@Override
	protected void init() {
		DCharts demo1 = DemoChart1();
		DCharts demo2 = DemoChart2();
		DCharts demo3 = DemoChart3();

		TabSheet tabSheet = new TabSheet();
		tabSheet.addTab(demo1, "Demo 1");
		tabSheet.addTab(demo2, "Demo 2");
		tabSheet.addTab(demo3, "Demo 3");
		setChart(tabSheet);

		setJqPlotCode(null);
		setDChatsCode(null);
	}

	private DCharts DemoChart1() {
		DataSeries dataSeries = new DataSeries().add(2, 6, 7, 10);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR);

		Axes axes = new Axes().addAxis(new XYaxis().setRenderer(
				AxisRenderers.CATEGORY).setTicks(
				new Ticks().add("a", "b", "c", "d")));

		Highlighter highlighter = new Highlighter().setShow(false);

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setAxes(axes).setHighlighter(highlighter);

		DCharts chart = new DCharts();
		chart.setHeight(600, Unit.PIXELS);
		chart.setMargins(0, 10, 10, 10);
		chart.setDataSeries(dataSeries).setOptions(options).show();
		return chart;
	}

	private DCharts DemoChart2() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries();
		dataSeries.add("a", 6).add("b", 8).add("c", 14).add("d", 20);
		dataSeries.newSeries();
		dataSeries.add("a", 8).add("b", 12).add("c", 6).add("d", 9);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.DONUT).setRendererOptions(
				new DonutRenderer().setSliceMargin(3).setStartAngle(-90)
						.setShowDataLabels(true)
						.setDataLabels(DataLabels.VALUE));

		Legend legend = new Legend().setShow(true)
				.setPlacement(LegendPlacements.OUTSIDE_GRID)
				.setLocation(LegendLocations.WEST);

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend);

		DCharts chart = new DCharts();
		chart.setHeight(600, Unit.PIXELS);
		chart.setMargins(0, 10, 10, 10);
		chart.setDataSeries(dataSeries).setOptions(options).show();
		return chart;
	}

	private DCharts DemoChart3() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, Math.cos(i));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, Math.sin(i - 0.8));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, 2.5 + Math.pow(i / 4, 2));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, -2.5 - Math.pow(i / 4, 2));
		}

		Series series = new Series()
				.addSeries(
						new XYseries().setLineWidth(2).setMarkerOptions(
								new MarkerRenderer()
										.setStyle(MarkerStyles.DIAMOND)))
				.addSeries(
						new XYseries(Yaxes.Y2).setShowLine(false)
								.setMarkerOptions(
										new MarkerRenderer().setSize(7)
												.setStyle(MarkerStyles.X)))
				.addSeries(
						new XYseries(Yaxes.Y3)
								.setMarkerOptions(new MarkerRenderer()
										.setStyle(MarkerStyles.CIRCLE)))
				.addSeries(
						new XYseries(Yaxes.Y4).setLineWidth(5)
								.setMarkerOptions(
										new MarkerRenderer().setStyle(
												MarkerStyles.FILLED_SQUARE)
												.setSize(10)));

		AxesDefaults axesDefaults = new AxesDefaults().setUseSeriesColor(true)
				.setRendererOptions(
						new LinearAxisRenderer().setAlignTicks(true));

		Axes axes = new Axes().addAxis(new XYaxis(XYaxes.Y))
				.addAxis(new XYaxis(XYaxes.Y2)).addAxis(new XYaxis(XYaxes.Y3))
				.addAxis(new XYaxis(XYaxes.Y4));

		Options options = new Options().setSeries(series)
				.setAxesDefaults(axesDefaults).setAxes(axes);

		DCharts chart = new DCharts();
		chart.setHeight(600, Unit.PIXELS);
		chart.setMargins(0, 10, 10, 10);
		chart.setDataSeries(dataSeries).setOptions(options).show();
		return chart;
	}

}
