/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.bubble;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.BubbleRenderer;

public class BubbleChartWithTransparentBubbles extends ChartContext {

	private static final long serialVersionUID = -3417785257705925082L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries()
				.add(11, 123, 1236, "Acura").add(45, 92, 1067, "Alfa Romeo")
				.add(24, 104, 1176, "AM General")
				.add(50, 23, 610, "Aston Martin Lagonda")
				.add(18, 17, 539, "Audi").add(7, 89, 864, "BMW")
				.add(2, 13, 1026, "Bugatti");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BUBBLE)
				.setRendererOptions(
						new BubbleRenderer().setBubbleAlpha(0.6f)
								.setHighlightAlpha(0.8f)).setShadow(true)
				.setShadowAlpha(0.05f);

		Options options = new Options().setSeriesDefaults(seriesDefaults);

		DCharts chart = new DCharts();
		chart.setWidth(450, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\n"//
				+ "\tvar arr = [[11, 123, 1236, \"Acura\"], [45, 92, 1067, \"Alfa Romeo\"],\n"//
				+ "\t[24, 104, 1176, \"AM General\"], [50, 23, 610, \"Aston Martin Lagonda\"],\n"//
				+ "\t[18, 17, 539, \"Audi\"], [7, 89, 864, \"BMW\"], [2, 13, 1026, \"Bugatti\"]];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('chart',[arr],{\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer: $.jqplot.BubbleRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tbubbleAlpha: 0.6,\n"//
				+ "\t\t\t\thighlightAlpha: 0.8\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tshadow: true,\n"//
				+ "\t\t\tshadowAlpha: 0.05\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(11, 123, 1236, \"Acura\")\n"//
				+ "\t.add(45, 92, 1067, \"Alfa Romeo\")\n"//
				+ "\t.add(24, 104, 1176, \"AM General\")\n"//
				+ "\t.add(50, 23, 610, \"Aston Martin Lagonda\")\n"//
				+ "\t.add(18, 17, 539, \"Audi\")\n"//
				+ "\t.add(7, 89, 864, \"BMW\")\n"//
				+ "\t.add(2, 13, 1026, \"Bugatti\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BUBBLE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BubbleRenderer()\n"//
				+ "\t\t\t.setBubbleAlpha(0.6f)\n"//
				+ "\t\t\t.setHighlightAlpha(0.8f))\n"//
				+ "\t.setShadow(true)\n"//
				+ "\t.setShadowAlpha(0.05f);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}
}
