/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.pie;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.ChartImageFormat;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.SeriesToggles;
import org.dussan.vaadin.dcharts.metadata.locations.LegendLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.LegendRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.series.PieRenderer;

public class PieChartWithEnhancedLegendAndResetAxesOff extends ChartContext {

	private static final long serialVersionUID = 3330867217098605460L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries().add("none", 23)
				.newSeries().add("error", 10).newSeries().add("click", 5)
				.newSeries().add("impression", 25);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.PIE).setRendererOptions(
				new PieRenderer().setShowDataLabels(true));

		Legend legend = new Legend()
		.setShow(true)
		.setPlacement(LegendPlacements.OUTSIDE_GRID)
		.setLocation(LegendLocations.SOUTH)
		.setLocation(LegendLocations.WEST)
		.setRenderer(LegendRenderers.ENHANCED)
		.setRendererOptions(
				new EnhancedLegendRenderer().setSeriesToggle(
						SeriesToggles.NORMAL).setSeriesToggleReplot(
						false));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend);

		DCharts chart = new DCharts();
		chart.setWidth(450, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);
		chart.setEnableDownload(true);
		chart.setChartImageFormat(ChartImageFormat.GIF);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar plot = $.jqplot('pie', [[[\"none\",23]],[[\"error\",10]],[[\"click\",5]],[[\"impression\",25]]], {\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.PieRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tshowDataLabels: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tlegend: {\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\tplacement: 'outsideGrid',\n"//
				+ "\t\t\t\tlocation: 's'\n"//
				+ "\t\t\t\trenderer: $.jqplot.EnhancedLegendRenderer,\n"//
				+ "\t\t\t\trendererOptions: {\n"//
				+ "\t\t\t\t\tseriesToggle: 'normal',\n"//
				+ "\t\t\t\t\tseriesToggleReplot: false\n"//
				+ "\t\t\t\t}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"none\", 23)\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"error\", 10)\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"click\", 5)\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"impression\", 25);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.PIE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew PieRenderer()\n"//
				+ "\t\t\t.setShowDataLabels(true));\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setPlacement(LegendPlacements.OUTSIDE_GRID)\n"//
				+ "\t.setLocation(LegendLocations.SOUTH);\n"//
				+ "\t.setRenderer(LegendRenderers.ENHANCED);\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setSeriesToggle(SeriesToggles.SLOW)\n"//
				+ "\t\t\t.setSeriesToggleReplot(false));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.setEnableDownload(true)\n"//
				+ "\t.setChartImageFormat(ChartImageFormat.GIF)\n"//
				+ "\t.show();");
	}

}
