/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum AdditionalOptions implements ChartType {

	// definition: chart type, chart, is new
	DEFAULT("additionalOptions", "Additional options", "Additional options",
			false), //
	HIDE_SHOW_AREA("hideShowArea", "Hide or show area", "Hide or show area",
			false), //
	SAVE_CHART_IMAGE("saveChartImage", "Save chart image", "Save chart image",
			false), //
	CHARTS_PLACED_IN_TABS("chartsPlacedInTabs", "Charts placed in tabs",
			"Charts placed in tabs", false), //
	MORE_CHARTS_IN_SAME_LAYOUT("moreChartsInSameLayout",
			"More charts in same layout", "More charts in same layout", false), //
	CHART_WITH_CANVAS_OVERLAY("chartWithCanvasOverlay",
			"Chart with canvas overlay", "Chart with canvas overlay", false), //
	CHART_ZOOM_ON_LEGEND_CLICK_EVENT("chartZoomOnLegendClickEvent",
			"Chart zoom on legend click event",
			"Chart zoom on legend click event", false);

	private final List<Object> chart;

	private AdditionalOptions(Object... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<Object> getValues() {
		return chart;
	}

	public static AdditionalOptions fromString(String chart) {
		if (chart != null) {
			for (AdditionalOptions tempChart : AdditionalOptions.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0).toString();
	}

	@Override
	public String getDescription() {
		return chart.get(1).toString();
	}

	@Override
	public String getLongDescription() {
		return chart.get(2).toString();
	}

	@Override
	public boolean isNew() {
		return Boolean.parseBoolean(chart.get(3).toString());
	}

	@Override
	public String toString() {
		return getPath();
	}

}
