/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui;

import javax.servlet.ServletContext;

import org.dussan.vaadin.dcharts.DCharts;

import com.vaadin.event.LayoutEvents.LayoutClickEvent;
import com.vaadin.event.LayoutEvents.LayoutClickListener;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;

public class Header extends VerticalLayout implements LayoutClickListener {

	private static final long serialVersionUID = -4395587629113871514L;
	private boolean isAttached = false;

	public Header() {
	}

	private void init() {
		setStyleName("header");
		setSizeUndefined();
		setWidth(100, Unit.PERCENTAGE);
		addLayoutClickListener((LayoutClickListener) this);

		Label title = new Label("dCharts Demo Gallery");
		title.setId("title");
		title.setSizeUndefined();
		addComponent(title);
		setComponentAlignment(title, Alignment.TOP_CENTER);

		ServletContext servletContext = VaadinServlet.getCurrent()
				.getServletContext();
		Label version = new Label("( dChartsDemo - "
				+ ManifestReader.getVersion(servletContext) + "  ,  dChart - "
				+ DCharts.getVersion() + "-" + DCharts.getGitVersion()
				+ "  ,  jqPlot - " + DCharts.getJqPlotVersion() + " )");
		version.setId("version");
		version.setSizeUndefined();
		addComponent(version);
		setComponentAlignment(version, Alignment.TOP_CENTER);
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			init();
		}
	}

	@Override
	public void detach() {
		super.detach();
		removeLayoutClickListener((LayoutClickListener) this);
	}

	@Override
	public void layoutClick(LayoutClickEvent event) {
		Page.getCurrent().setUriFragment("");
	}

}
