/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui.tree;

import com.vaadin.ui.Panel;

public class TreePanel extends Panel {

	private static final long serialVersionUID = 703996340144118973L;
	private boolean isAttached = false;
	private ChartsTree chartsTree = null;

	public TreePanel() {
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			chartsTree = new ChartsTree();
			isAttached = true;
			setStyleName("tree");
			setSizeUndefined();
			setWidth(310, Unit.PIXELS);
			setHeight(100, Unit.PERCENTAGE);
			setContent(chartsTree);
		}
	}

	public void processChangedFragment(String fragment) {
		chartsTree.processChangedFragment(fragment);
	}

}
