/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo;

import org.dussan.dchartsdemo.ui.Header;
import org.dussan.dchartsdemo.ui.context.ContextPanel;
import org.dussan.dchartsdemo.ui.tree.TreePanel;

import com.vaadin.annotations.Theme;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.Page.UriFragmentChangedEvent;
import com.vaadin.server.Page.UriFragmentChangedListener;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.UI;

@Theme("dchartsTheme")
public class DChartsDemoUI extends UI {

	private static final long serialVersionUID = -9098675463698747649L;
	private String fragment = null;
	private TreePanel treePanel = null;
	private ContextPanel contextPanel = null;

	@Override
	protected void init(VaadinRequest request) {
		GridLayout main = new GridLayout(2, 2);
		main.setStyleName("demo");
		main.setSizeFull();
		main.setSpacing(false);
		main.setRowExpandRatio(1, 1.0f);
		main.setColumnExpandRatio(1, 1.0f);
		setContent(main);

		fragment = new String();
		treePanel = new TreePanel();
		contextPanel = new ContextPanel();
		main.addComponent(new Header(), 0, 0, 1, 0);
		main.addComponent(treePanel, 0, 1);
		main.addComponent(contextPanel, 1, 1);

		Page.getCurrent().addUriFragmentChangedListener(
				new UriFragmentChangedListener() {
					private static final long serialVersionUID = -5342904976136437168L;

					@Override
					public void uriFragmentChanged(UriFragmentChangedEvent event) {
						String tempFragment = event.getUriFragment();
						tempFragment = tempFragment != null ? tempFragment
								: new String();
						if (fragment != null && !fragment.equals(tempFragment)) {
							treePanel.processChangedFragment(tempFragment);
							contextPanel.processChangedFragment(tempFragment);
							fragment = tempFragment;
						}
					}
				});
	}

}
