/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.additional;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.locations.LegendLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.LabelRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.LegendRenderers;
import org.dussan.vaadin.dcharts.metadata.ticks.TickFormatters;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Grid;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.options.Title;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.tick.CanvasAxisTickRenderer;

public class HideShowAreaChart extends ChartContext {

	private static final long serialVersionUID = 5725486954311744223L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries() //
				.add(0.9176, 0.9296, 0.927, 0.9251, 0.9241, 0.9225, 0.9197,
						0.9164, 0.9131, 0.9098, 0.9064, 0.9028, 0.8991, 0.8957,
						0.8925, 0.8896, 0.8869, 0.8844, 0.882, 0.8797, 0.8776,
						0.8755, 0.8735, 0.8715, 0.8696, 0.8677, 0.8658, 0.8637,
						0.8616, 0.8594, 0.8572, 0.8548, 0.8524, 0.8499, 0.8473,
						0.8446, 0.8418, 0.8389, 0.8359, 0.8328, 0.8295, 0.8262,
						0.8227, 0.8191, 0.8155, 0.8119, 0.8083, 0.8048, 0.8013,
						0.7979, 0.7945, 0.7912, 0.7879, 0.7846, 0.7813, 0.778,
						0.7747, 0.7714, 0.768, 0.7647, 0.7612, 0.7577, 0.7538,
						0.7496, 0.7449, 0.7398, 0.7342, 0.7279, 0.721, 0.7137,
						0.7059, 0.6977, 0.6889, 0.6797, 0.6698, 0.6593, 0.6482,
						0.6367, 0.6247, 0.6121, 0.5989, 0.5852, 0.571, 0.5561,
						0.5402, 0.5232, 0.505, 0.4855, 0.4643, 0.4414, 0.4166,
						0.3893, 0.3577, 0.3204, 0.2764, 0.2272, 0.1774, 0.1231,
						0.0855, 0.0849) //
				.add(0.0824, 0.0704, 0.073, 0.0749, 0.0759, 0.0775, 0.0803,
						0.0836, 0.0869, 0.0902, 0.0936, 0.0972, 0.1009, 0.1043,
						0.1075, 0.1104, 0.1131, 0.1156, 0.118, 0.1203, 0.1224,
						0.1245, 0.1265, 0.1285, 0.1304, 0.1323, 0.1342, 0.1363,
						0.1384, 0.1406, 0.1428, 0.1452, 0.1476, 0.1501, 0.1527,
						0.1554, 0.1582, 0.1611, 0.1641, 0.1672, 0.1705, 0.1738,
						0.1773, 0.1809, 0.1845, 0.1881, 0.1917, 0.1952, 0.1987,
						0.2021, 0.2055, 0.2088, 0.2121, 0.2154, 0.2187, 0.222,
						0.2253, 0.2286, 0.232, 0.2353, 0.2388, 0.2423, 0.2462,
						0.2504, 0.2551, 0.2602, 0.2658, 0.2721, 0.279, 0.2863,
						0.2941, 0.3023, 0.3111, 0.3203, 0.3302, 0.3407, 0.3518,
						0.3633, 0.3753, 0.3879, 0.4011, 0.4148, 0.429, 0.4439,
						0.4598, 0.4768, 0.495, 0.5145, 0.5357, 0.5586, 0.5834,
						0.6107, 0.6423, 0.6796, 0.7236, 0.7728, 0.8226, 0.8769,
						0.9145, 0.9151);

		Title title = new Title(
				"Contribution of Urban and Rural Population to National Percentiles (edited data)");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setShowMarker(false).setFill(true).setFillAndStroke(true);

		Legend legend = new Legend()
				.setShow(true)
				.setRenderer(LegendRenderers.ENHANCED)
				.setRendererOptions(
						new EnhancedLegendRenderer().setNumberRows(1))
				.setPlacement(LegendPlacements.OUTSIDE_GRID)
				.setLabels("Rural", "Urban").setLocation(LegendLocations.SOUTH);

		Axes axes = new Axes().addAxis(
				new XYaxis(XYaxes.X)
						.setPad(0)
						.setMin(1)
						.setMax(100)
						.setLabel("Population Percentile")
						.setLabelRenderer(LabelRenderers.CANVAS)
						.setTickInterval(3)
						.setTickOptions(
								new CanvasAxisTickRenderer()
										.setShowGridline(false))).addAxis(
				new XYaxis(XYaxes.Y)
						.setMin(0)
						.setMax(1)
						.setLabel("Percentage of Population")
						.setLabelRenderer(LabelRenderers.CANVAS)
						.setTickOptions(
								new CanvasAxisTickRenderer()
										.setFormatter(TickFormatters.PERCENT)
										.setShowGridline(false)
										.setFormatString("%d%%")));

		Grid grid = new Grid().setDrawBorder(false).setShadow(false)
				.setBackground("white");

		Options options = new Options().setTitle(title).setStackSeries(true)
				.setSeriesColors("#77933C", "#B9CDE5")
				.setSeriesDefaults(seriesDefaults).setLegend(legend)
				.setAxes(axes).setGrid(grid);

		DCharts chart = new DCharts();
		chart.setWidth(750, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setMarginRight(10);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tplot1 = $.jqplot('chart1', [data.rural, data.urban], {\n"//
				+ "\t\ttitle: 'Contribution of Urban and Rural Population to National Percentiles (edited data)',\n"//
				+ "\t\tstackSeries: true,\n"//
				+ "\t\tseriesColors: ['#77933C', '#B9CDE5'],\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\tshowMarker: false,\n"//
				+ "\t\t\tfill: true,\n"//
				+ "\t\t\tfillAndStroke: true\n"//
				+ "\t\t},\n"//
				+ "\t\tlegend: {\n"//
				+ "\t\t\tshow: true,\n"//
				+ "\t\t\trenderer: $.jqplot.EnhancedLegendRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tnumberRows: 1\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tplacement: 'outsideGrid',\n"//
				+ "\t\t\tlabels: labels,\n"//
				+ "\t\t\tlocation: 's'\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\tpad: 0,\n"//
				+ "\t\t\t\tmin: 1,\n"//
				+ "\t\t\t\tmax: 100,\n"//
				+ "\t\t\t\tlabel: 'Population Percentile',\n"//
				+ "\t\t\t\tlabelRenderer: $.jqplot.CanvasAxisLabelRenderer,\n"//
				+ "\t\t\t\ttickInterval: 3,\n"//
				+ "\t\t\t\ttickOptions: {\n"//
				+ "\t\t\t\t\tshowGridline: false\n"//
				+ "\t\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\tyaxis: {\n"//
				+ "\t\t\tmin: 0,\n"//
				+ "\t\t\tmax: 1,\n"//
				+ "\t\t\tlabel: 'Percentage of Population',\n"//
				+ "\t\t\tlabelRenderer: $.jqplot.CanvasAxisLabelRenderer,\n"//
				+ "\t\t\ttickOptions: {\n"//
				+ "\t\t\t\tformatter: $.jqplot.PercentTickFormatter,\n"//
				+ "\t\t\t\tshowGridline: false,\n"//
				+ "\t\t\t\tformatString: '%d%%'\n"//
				+ "\t\t\t}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\tgrid: {\n"//
				+ "\t\t\tdrawBorder: false,\n"//
				+ "\t\t\tshadow: false,\n"//
				+ "\t\t\t// background: 'rgba(0,0,0,0)'  works to make transparent.\n"//
				+ "\t\t\tbackground: 'white'\n"//
				+ "\t\t}\n"//
				+ "\t}\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(0.9176, 0.9296, 0.927, 0.9251, 0.9241, 0.9225, 0.9197, 0.9164, 0.9131, 0.9098, 0.9064, 0.9028, 0.8991, 0.8957, 0.8925, 0.8896, 0.8869, 0.8844, 0.882, 0.8797, 0.8776, 0.8755, 0.8735, 0.8715, 0.8696, 0.8677, 0.8658, 0.8637, 0.8616, 0.8594, 0.8572, 0.8548, 0.8524, 0.8499, 0.8473, 0.8446, 0.8418, 0.8389, 0.8359, 0.8328, 0.8295, 0.8262, 0.8227, 0.8191, 0.8155, 0.8119, 0.8083, 0.8048, 0.8013, 0.7979, 0.7945, 0.7912, 0.7879, 0.7846, 0.7813, 0.778, 0.7747, 0.7714, 0.768, 0.7647, 0.7612, 0.7577, 0.7538, 0.7496, 0.7449, 0.7398, 0.7342, 0.7279, 0.721, 0.7137, 0.7059, 0.6977, 0.6889, 0.6797, 0.6698, 0.6593, 0.6482, 0.6367, 0.6247, 0.6121, 0.5989, 0.5852, 0.571, 0.5561, 0.5402, 0.5232, 0.505, 0.4855, 0.4643, 0.4414, 0.4166, 0.3893, 0.3577, 0.3204, 0.2764, 0.2272, 0.1774, 0.1231, 0.0855, 0.0849)\n"// //
				+ "\t.add(0.0824, 0.0704, 0.073, 0.0749, 0.0759, 0.0775, 0.0803, 0.0836, 0.0869, 0.0902, 0.0936, 0.0972, 0.1009, 0.1043, 0.1075, 0.1104, 0.1131, 0.1156, 0.118, 0.1203, 0.1224, 0.1245, 0.1265, 0.1285, 0.1304, 0.1323, 0.1342, 0.1363, 0.1384, 0.1406, 0.1428, 0.1452, 0.1476, 0.1501, 0.1527, 0.1554, 0.1582, 0.1611, 0.1641, 0.1672, 0.1705, 0.1738, 0.1773, 0.1809, 0.1845, 0.1881, 0.1917, 0.1952, 0.1987, 0.2021, 0.2055, 0.2088, 0.2121, 0.2154, 0.2187, 0.222, 0.2253, 0.2286, 0.232, 0.2353, 0.2388, 0.2423, 0.2462, 0.2504, 0.2551, 0.2602, 0.2658, 0.2721, 0.279, 0.2863, 0.2941, 0.3023, 0.3111, 0.3203, 0.3302, 0.3407, 0.3518, 0.3633, 0.3753, 0.3879, 0.4011, 0.4148, 0.429, 0.4439, 0.4598, 0.4768, 0.495, 0.5145, 0.5357, 0.5586, 0.5834, 0.6107, 0.6423, 0.6796, 0.7236, 0.7728, 0.8226, 0.8769, 0.9145, 0.9151);\n"//
				+ "\n"//
				+ "Title title = new Title(\"Contribution of Urban and Rural Population to National Percentiles (edited data)\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\tsetShowMarker(false)\n"//
				+ "\tsetFill(true)\n"//
				+ "\tsetFillAndStroke(true);\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\tsetShow(true)\n"//
				+ "\tsetRenderer(LegendRenderers.ENHANCED)\n"//
				+ "\tsetRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setNumberRows(1))\n"//
				+ "\tsetPlacement(LegendPlacements.OUTSIDE_GRID)\n"//
				+ "\tsetLabels(\"Rural\", \"Urban\")\n"//
				+ "\tsetLocation(LegendLocations.SOUTH);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.X)\n"//
				+ "\t\t\tsetPad(0)\n"//
				+ "\t\t\tsetMin(1)\n"//
				+ "\t\t\tsetMax(100)\n"//
				+ "\t\t\tsetLabel(\"Population Percentile\")\n"//
				+ "\t\t\tsetLabelRenderer(LabelRenderers.CANVAS)\n"//
				+ "\t\t\tsetTickInterval(3)\n"//
				+ "\t\t\tsetTickOptions(\n"//
				+ "\t\t\t\tnew CanvasAxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setShowGridline(false)))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\tsetMin(0)\n"//
				+ "\t\t\tsetMax(1)\n"//
				+ "\t\t\tsetLabel(\"Percentage of Population\")\n"//
				+ "\t\t\tsetLabelRenderer(LabelRenderers.CANVAS)\n"//
				+ "\t\t\tsetTickOptions(\n"//
				+ "\t\t\t\tnew CanvasAxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setFormatter(TickFormatters.PERCENT)\n"//
				+ "\t\t\t\t\t.setShowGridline(false)\n"//
				+ "\t\t\t\t\t.setFormatString(\"%d%%\")));\n"//
				+ "\n"//
				+ "Grid grid = new Grid()\n"//
				+ "\tsetDrawBorder(false)\n"//
				+ "\tsetShadow(false)\n"//
				+ "\tsetBackground(\"white\");\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setTitle(title)\n"//
				+ "\t.setStackSeries(true)\n"//
				+ "\t.setSeriesColors(\"#77933C\", \"#B9CDE5\")\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setGrid(grid);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
