/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.block;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.ChartImageFormat;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.SeriesToggles;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.LegendRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.series.BlockRenderer;

public class BlockChartWithEnhancedLegendAndResetAxesOn extends ChartContext {

	private static final long serialVersionUID = -3679249639565843052L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries()
				.newSeries()
				.add(0.9, 120, "Vernors")
				.add(1.8, 140, "Fanta")
				.add(3.2, 90, "Barqs", "{background:'#ddbb33'}")
				.add(4.1, 140, "Arizon Iced Tea")
				.add(4.5, 91, "Red Bull")
				.add(6.8, 17, "Go Girl")
				//
				.newSeries().add(1.3, 44, "Pepsi").add(2.1, 170, "Sierra Mist")
				.add(2.6, 66, "Moutain Dew")
				.add(4, 52, "Sobe")
				.add(5.4, 16, "Amp")
				.add(6, 48, "Aquafina")
				//
				.newSeries()
				.add(1, 59, "Coca-Cola", "{background:'rgb(250, 160, 160)'}")
				.add(2, 50, "Ambasa").add(3, 90, "Mello Yello")
				.add(4, 90, "Sprite").add(5, 71, "Squirt").add(5, 155, "Youki");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BLOCK);

		Legend legend = new Legend()
				.setShow(true)
				.setRenderer(LegendRenderers.ENHANCED)
				.setRendererOptions(
						new EnhancedLegendRenderer().setSeriesToggle(
								SeriesToggles.NORMAL).setSeriesToggleReplot(
								true));

		Axes axes = new Axes()
				.addAxis(new XYaxis(XYaxes.X).setMin(0).setMax(8)).addAxis(
						new XYaxis(XYaxes.Y).setMin(0).setMax(200));

		Series series = new Series()
				.addSeries(new XYseries())
				.addSeries(
						new XYseries()
								.setRenderer(SeriesRenderers.BLOCK)
								.setRendererOptions(
										new BlockRenderer()
												.setCss("{background:'#A1EED6'}")))
				.addSeries(
						new XYseries()
								.setRenderer(SeriesRenderers.BLOCK)
								.setRendererOptions(
										new BlockRenderer()
												.setCss("{background:'#D3E4A0'}")));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend).setAxes(axes).setSeries(series);

		DCharts chart = new DCharts();
		chart.setWidth(500, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);
		chart.setEnableDownload(true);
		chart.setChartImageFormat(ChartImageFormat.GIF);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [[0.9, 120, 'Vernors'], [1.8, 140, 'Fanta'], [3.2, 90, 'Barqs', {background:'#ddbb33'}],\n"//
				+ "\t\t[4.1, 140, 'Arizon Iced Tea'], [4.5, 91, 'Red Bull'], [6.8, 17, 'Go Girl']];\n"//
				+ "\tvar s2 = [[1.3, 44, 'Pepsi'], [2.1, 170, 'Sierra Mist'], [2.6, 66, 'Moutain Dew'],\n"//
				+ "\t\t[4, 52, 'Sobe'], [5.4, 16, 'Amp'], [6, 48, 'Aquafina']];\n"//
				+ "\tvar s3 = [[1, 59, 'Coca-Cola', {background:'rgb(250, 160, 160)'}], [2, 50, 'Ambasa'],\n"//
				+ "\t\t[3, 90, 'Mello Yello'], [4, 90, 'Sprite'], [5, 71, 'Squirt'], [5, 155, 'Youki']];\n"//
				+ "\n"//
				+ "\t$('#chart1').jqplot([s1, s2, s3],{\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BlockRenderer\n"//
				+ "\t\t},\n"//
				+ "\t\tlegend:{\n"//
				+ "\t\t\tshow:true\n"//
				+ "\t\t\trenderer: $.jqplot.EnhancedLegendRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tseriesToggle: 'normal',\n"//
				+ "\t\t\t\tseriesToggleReplot: {resetAxes: true}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t},\n"//
				+ "\t\tseries: [\n"//
				+ "\t\t\t{},\n"//
				+ "\t\t\t{rendererOptions: {\n"//
				+ "\t\t\t\tcss:{background:'#A1EED6'}\n"//
				+ "\t\t\t}},\n"//
				+ "\t\t\t{rendererOptions: {\n"//
				+ "\t\t\t\tcss:{background:'#D3E4A0'}\n"//
				+ "\t\t\t}}\n"//
				+ "\t\t],\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\tmin:0,\n"//
				+ "\t\t\t\tmax: 8\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\tmin:0,\n"//
				+ "\t\t\t\tmax: 200\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(0.9, 120, \"Vernors\")\n"//
				+ "\t\t.add(1.8, 140, \"Fanta\")\n"//
				+ "\t\t.add(3.2, 90, \"Barqs\", \"{background:'#ddbb33'}\")\n"//
				+ "\t\t.add(4.1, 140, \"Arizon Iced Tea\")\n"//
				+ "\t\t.add(4.5, 91, \"Red Bull\")\n"//
				+ "\t\t.add(6.8, 17, \"Go Girl\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(1.3, 44, \"Pepsi\")\n"//
				+ "\t\t.add(2.1, 170, \"Sierra Mist\")\n"//
				+ "\t\t.add(2.6, 66, \"Moutain Dew\")\n"//
				+ "\t\t.add(4, 52, \"Sobe\")\n"//
				+ "\t\t.add(5.4, 16, \"Amp\")\n"//
				+ "\t\t.add(6, 48, \"Aquafina\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(1, 59, \"Coca-Cola\", \"{background:'rgb(250, 160, 160)'}\")\n"//
				+ "\t\t.add(2, 50, \"Ambasa\")\n"//
				+ "\t\t.add(3, 90, \"Mello Yello\")\n"//
				+ "\t\t.add(4, 90, \"Sprite\")\n"//
				+ "\t\t.add(5, 71, \"Squirt\")\n"//
				+ "\t\t.add(5, 155, \"Youki\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BLOCK);\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setRenderer(LegendRenderers.ENHANCED);\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setSeriesToggle(SeriesToggles.SLOW)\n"//
				+ "\t\t\t.setSeriesToggleReplot(true));\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.X)\n"//
				+ "\t\t\t.setMin(0)\n"//
				+ "\t\t\t.setMax(8))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setMin(0)\n"//
				+ "\t\t\t.setMax(200));\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(new XYseries())\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew BlockRenderer()\n"//
				+ "\t\t\t\t\t.setCss(\"background:'#A1EED6'\")))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew BlockRenderer()\n"//
				+ "\t\t\t\t\t.setCss(\"background:'#D3E4A0'\")));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setSeries(series);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.setEnableDownload(true)\n"//
				+ "\t.setChartImageFormat(ChartImageFormat.GIF)\n"//
				+ "\t.show();");
	}
}
