/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.block;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.PointLabels;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.BlockRenderer;

public class BlockChartWithVaryBlockColors extends ChartContext {

	private static final long serialVersionUID = -3679249639565843052L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries()
				.add(0.9, 120, "Vernors")
				.add(1.8, 140, "Fanta")
				.add(3.2, 90, "Barqs")
				.add(4.1, 140, "Arizon Iced Tea")
				.add(4.5, 91, "Red Bull")
				.add(6.8, 17, "Go Girl")
				//
				.newSeries().add(1.3, 44, "Pepsi").add(2.1, 170, "Sierra Mist")
				.add(2.6, 66, "Moutain Dew").add(4, 52, "Sobe")
				.add(5.4, 16, "Amp")
				.add(6, 48, "Aquafina")
				//
				.newSeries().add(1, 59, "Coca-Cola").add(2, 50, "Ambasa")
				.add(3, 90, "Mello Yello").add(4, 90, "Sprite")
				.add(5, 71, "Squirt").add(5, 155, "Youki");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BLOCK)
				.setRendererOptions(
						new BlockRenderer().setVaryBlockColors(true))
				.setPointLabels(new PointLabels().setShow(false));

		Legend legend = new Legend().setShow(true);

		Axes axes = new Axes()
				.addAxis(new XYaxis(XYaxes.X).setMin(0).setMax(8)).addAxis(
						new XYaxis(XYaxes.Y).setMin(0).setMax(200));

		Series series = new Series()
				.addSeries(
						new XYseries().setRenderer(SeriesRenderers.BLOCK)
								.setLabel("Independent Brands"))
				.addSeries(
						new XYseries().setRenderer(SeriesRenderers.BLOCK)
								.setLabel("Pepsi Brands"))
				.addSeries(
						new XYseries().setRenderer(SeriesRenderers.BLOCK)
								.setLabel("Coke Brands"));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend).setAxes(axes).setSeries(series);

		DCharts chart = new DCharts();
		chart.setWidth(500, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [[0.9, 120, 'Vernors'], [1.8, 140, 'Fanta'], [3.2, 90, 'Barqs'],\n"//
				+ "\t\t[4.1, 140, 'Arizon Iced Tea'], [4.5, 91, 'Red Bull'], [6.8, 17, 'Go Girl']];\n"//
				+ "\tvar s2 = [[1.3, 44, 'Pepsi'], [2.1, 170, 'Sierra Mist'], [2.6, 66, 'Moutain Dew'],\n"//
				+ "\t\t[4, 52, 'Sobe'], [5.4, 16, 'Amp'], [6, 48, 'Aquafina']];\n"//
				+ "\tvar s3 = [[1, 59, 'Coca-Cola'], [2, 50, 'Ambasa'], [3, 90, 'Mello Yello'],\n"//
				+ "\t\t[4, 90, 'Sprite'], [5, 71, 'Squirt'], [5, 155, 'Youki']];\n"//
				+ "\n"//
				+ "\t$('#chart1').jqplot([s1, s2, s3],{\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BlockRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tvaryBlockColors: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tpointLabels:{\n"//
				+ "\t\t\t\tshow: false\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\tlegend:{\n"//
				+ "\t\t\tshow:true\n"//
				+ "\t\t},\n"//
				+ "\t\tseries: [{label: 'Independent Brands'}, {label: 'Pepsi Brands'}, {label: 'Coke Brands'}],\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\tmin:0,\n"//
				+ "\t\t\t\tmax: 8\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\tmin:0,\n"//
				+ "\t\t\t\tmax: 200\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(0.9, 120, \"Vernors\")\n"//
				+ "\t\t.add(1.8, 140, \"Fanta\")\n"//
				+ "\t\t.add(3.2, 90, \"Barqs\")\n"//
				+ "\t\t.add(4.1, 140, \"Arizon Iced Tea\")\n"//
				+ "\t\t.add(4.5, 91, \"Red Bull\")\n"//
				+ "\t\t.add(6.8, 17, \"Go Girl\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(1.3, 44, \"Pepsi\")\n"//
				+ "\t\t.add(2.1, 170, \"Sierra Mist\")\n"//
				+ "\t\t.add(2.6, 66, \"Moutain Dew\")\n"//
				+ "\t\t.add(4, 52, \"Sobe\")\n"//
				+ "\t\t.add(5.4, 16, \"Amp\")\n"//
				+ "\t\t.add(6, 48, \"Aquafina\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t\t.add(1, 59, \"Coca-Cola\")\n"//
				+ "\t\t.add(2, 50, \"Ambasa\")\n"//
				+ "\t\t.add(3, 90, \"Mello Yello\")\n"//
				+ "\t\t.add(4, 90, \"Sprite\")\n"//
				+ "\t\t.add(5, 71, \"Squirt\")\n"//
				+ "\t\t.add(5, 155, \"Youki\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BlockRenderer()\n"//
				+ "\t\t\t.setVaryBlockColors(true))\n"//
				+ "\t.setPointLabels(\n"//
				+ "\t\tnew PointLabels()\n"//
				+ "\t\t\t.setShow(false));\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.X)\n"//
				+ "\t\t\t.setMin(0)\n"//
				+ "\t\t\t.setMax(8))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setMin(0)\n"//
				+ "\t\t\t.setMax(200));\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t\t\t.setLabel(\"Independent Brands\"))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t\t\t.setLabel(\"Pepsi Brands\"))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRenderer(SeriesRenderers.BLOCK)\n"//
				+ "\t\t\t.setLabel(\"Coke Brands\"))\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setSeries(series);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
