/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.bubble;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.ChartImageFormat;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.SeriesToggles;
import org.dussan.vaadin.dcharts.metadata.TooltipAxes;
import org.dussan.vaadin.dcharts.metadata.locations.TooltipLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.LegendRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.series.BubbleRenderer;

public class BubbleChartWithEnhancedLegendAndResetAxesOff extends ChartContext {

	private static final long serialVersionUID = -9010571315720871369L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries()
				.add(11, 123, 1236, "Acura").newSeries()
				.add(45, 92, 1067, "Alfa Romeo").newSeries()
				.add(24, 104, 1176, "AM General").newSeries()
				.add(50, 23, 610, "Aston Martin Lagonda").newSeries()
				.add(18, 17, 539, "Audi").newSeries().add(7, 89, 864, "BMW")
				.newSeries().add(2, 13, 1026, "Bugatti");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BUBBLE)
				.setRendererOptions(
						new BubbleRenderer().setBubbleAlpha(0.6f)
								.setHighlightAlpha(0.8f)).setShadow(true)
				.setShadowAlpha(0.05f);

		Legend legend = new Legend()
				.setShow(true)
				.setPlacement(LegendPlacements.OUTSIDE_GRID)
				.setRenderer(LegendRenderers.ENHANCED)
				.setRendererOptions(
						new EnhancedLegendRenderer().setSeriesToggle(
								SeriesToggles.NORMAL).setSeriesToggleReplot(
								false));

		Highlighter highlighter = new Highlighter().setShow(true)
				.setShowTooltip(true).setTooltipAlwaysVisible(true)
				.setKeepTooltipInsideChart(true)
				.setTooltipLocation(TooltipLocations.SOUTH_EAST)
				.setTooltipAxes(TooltipAxes.XY_BUBBLE);

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend).setHighlighter(highlighter);

		DCharts chart = new DCharts();
		chart.setWidth(450, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);
		chart.setEnableDownload(true);
		chart.setChartImageFormat(ChartImageFormat.GIF);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\n"//
				+ "\tvar arr = [[[11, 123, 1236, \"Acura\"]], [[45, 92, 1067, \"Alfa Romeo\"]],\n"//
				+ "\t[[24, 104, 1176, \"AM General\"]], [[50, 23, 610, \"Aston Martin Lagonda\"]],\n"//
				+ "\t[[18, 17, 539, \"Audi\"]], [[7, 89, 864, \"BMW\"]], [[2, 13, 1026, \"Bugatti\"]]];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('chart',arr,{\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer: $.jqplot.BubbleRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tbubbleAlpha: 0.6,\n"//
				+ "\t\t\t\thighlightAlpha: 0.8\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tshadow: true,\n"//
				+ "\t\t\tshadowAlpha: 0.05\n"//
				+ "\t\t},\n"//
				+ "\t\tlegend:{\n"//
				+ "\t\t\tshow:true\n"//
				+ "\t\t\trenderer: $.jqplot.EnhancedLegendRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tseriesToggle: 'normal',\n"//
				+ "\t\t\t\tseriesToggleReplot: false\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\thighlighter: {\n"//
				+ "\t\t\tshow: true,\n"//
				+ "\t\t\tshowTooltip: true,\n"//
				+ "\t\t\ttooltipAlwaysVisible: true,\n"//
				+ "\t\t\tkeepTooltipInsideChart: true,\n"//
				+ "\t\t\ttooltipLocation: 'se',\n"//
				+ "\t\t\ttooltipAxes: 'xybubble'\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(11, 123, 1236, \"Acura\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(45, 92, 1067, \"Alfa Romeo\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(24, 104, 1176, \"AM General\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(50, 23, 610, \"Aston Martin Lagonda\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(18, 17, 539, \"Audi\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(7, 89, 864, \"BMW\")\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(2, 13, 1026, \"Bugatti\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BUBBLE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BubbleRenderer()\n"//
				+ "\t\t\t.setBubbleAlpha(0.6f)\n"//
				+ "\t\t\t.setHighlightAlpha(0.8f))\n"//
				+ "\t.setShadow(true)\n"//
				+ "\t.setShadowAlpha(0.05f);\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setPlacement(LegendPlacements.OUTSIDE_GRID)\n"//
				+ "\t.setRenderer(LegendRenderers.ENHANCED);\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setSeriesToggle(SeriesToggles.SLOW)\n"//
				+ "\t\t\t.setSeriesToggleReplot(false));\n"//
				+ "\n"//
				+ "Highlighter highlighter = new Highlighter()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setShowTooltip(true)\n"//
				+ "\t.setTooltipAlwaysVisible(true)\n"//
				+ "\t.setKeepTooltipInsideChart(true)\n"//
				+ "\t.setTooltipLocation(TooltipLocations.SOUTH_EAST)\n"//
				+ "\t.setTooltipAxes(TooltipAxes.XY_BUBBLE);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend)\n"//
				+ "\t.setHighlighter(highlighter);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.setEnableDownload(true)\n"//
				+ "\t.setChartImageFormat(ChartImageFormat.GIF)\n"//
				+ "\t.show();");
	}
}
