/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.donut;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.ChartImageFormat;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.DataLabels;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.SeriesToggles;
import org.dussan.vaadin.dcharts.metadata.locations.LegendLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.LegendRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.series.DonutRenderer;

public class DonutChartWithEnhancedLegendAndResetAxesOn extends ChartContext {

	private static final long serialVersionUID = 738675289894786832L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries();
		dataSeries.add("a", 6).add("a", 8);
		dataSeries.newSeries();
		dataSeries.add("b", 8).add("b", 12).add("b", 6);
		dataSeries.newSeries();
		dataSeries.add("c", 14).add("c", 6);
		dataSeries.newSeries();
		dataSeries.add("d", 20).add("d", 9).add("d", 12);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.DONUT).setRendererOptions(
				new DonutRenderer().setSliceMargin(3).setStartAngle(-90)
						.setShowDataLabels(true)
						.setDataLabels(DataLabels.VALUE));

		Legend legend = new Legend()
				.setShow(true)
				.setPlacement(LegendPlacements.OUTSIDE_GRID)
				.setLocation(LegendLocations.WEST)
				.setRenderer(LegendRenderers.ENHANCED)
				.setRendererOptions(
						new EnhancedLegendRenderer().setSeriesToggle(
								SeriesToggles.NORMAL).setSeriesToggleReplot(
								true));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend);

		DCharts chart = new DCharts();
		chart.setWidth(450, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);
		chart.setEnableDownload(true);
		chart.setChartImageFormat(ChartImageFormat.GIF);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [['a',6], ['a', 8]];\n"//
				+ "\tvar s2 = [['b',8], ['b', 12], ['b', 6]];\n"//
				+ "\tvar s3 = [['c',14], ['c', 6]];\n"//
				+ "\tvar s4 = [['d',20], ['d', 9], ['d', 12]];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('donut', [s1, s2, s3, s4], {\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\trenderer:$.jqplot.DonutRenderer,\n"//
				+ "\t\t\trendererOptions:{\n"//
				+ "\t\t\t\tsliceMargin: 3,\n"//
				+ "\t\t\t\tstartAngle: -90,\n"//
				+ "\t\t\t\tshowDataLabels: true,\n"//
				+ "\t\t\t\tdataLabels: 'value'\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tlegend: {\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\tplacement: 'outsideGrid',\n"//
				+ "\t\t\t\tlocation: 'w'\n"//
				+ "\t\t\trenderer: $.jqplot.EnhancedLegendRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tseriesToggle: 'normal',\n"//
				+ "\t\t\t\tseriesToggleReplot: {resetAxes: true}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"a\", 6)\n"//
				+ "\t.add(\"a\", 8);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"b\", 8)\n"//
				+ "\t.add(\"b\", 12)\n"//
				+ "\t.add(\"b\", 6);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"c\", 14)\n"//
				+ "\t.add(\"c\", 6);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"d\", 20)\n"//
				+ "\t.add(\"d\", 9)\n"//
				+ "\t.add(\"d\", 12);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.DONUT)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew DonutRenderer()\n"//
				+ "\t\t\t.setSliceMargin(3)\n"//
				+ "\t\t\t.setStartAngle(-90))\n"//
				+ "\t\t\t.setShowDataLabels(true)\n"//
				+ "\t\t\t.setDataLabels(DataLabels.VALUE));\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setPlacement(LegendPlacements.OUTSIDE_GRID)\n"//
				+ "\t.setLocation(LegendLocations.WEST);\n"//
				+ "\t.setRenderer(LegendRenderers.ENHANCED);\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setSeriesToggle(SeriesToggles.SLOW)\n"//
				+ "\t\t\t.setSeriesToggleReplot(true));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\t.setLegend(legend);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.setEnableDownload(true)\n"//
				+ "\t.setChartImageFormat(ChartImageFormat.GIF)\n"//
				+ "\t.show();");
	}

}
