/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.metergauge;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.MeterGaugeRenderer;

public class MeterGaugeChartWithoutTickLabels extends ChartContext {

	private static final long serialVersionUID = 8356098828546366643L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().add(1);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.METER_GAUGE).setRendererOptions(
				new MeterGaugeRenderer().setShowTickLabels(false)
						.setIntervals(2, 3, 4)
						.setIntervalColors("#66cc66", "#E7E658", "#cc6666"));

		Options options = new Options().setSeriesDefaults(seriesDefaults);

		DCharts chart = new DCharts();
		chart.setWidth(120, Unit.PIXELS);
		chart.setHeight(80, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\ts1 = [1];\n"//
				+ "\tplot0 = $.jqplot('chart0',[s1],{\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\trenderer: $.jqplot.MeterGaugeRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tshowTickLabels: false,\n"//
				+ "\t\t\t\tintervals:[2,3,4],\n"//
				+ "\t\t\t\tintervalColors:['#66cc66', '#E7E658', '#cc6666']\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t);\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries().add(1);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.METER_GAUGE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew MeterGaugeRenderer()\n"//
				+ "\t\t\t.setShowTickLabels(false)\n"//
				+ "\t\t\t.setIntervals(2, 3, 4)\n"//
				+ "\t\t\t.setIntervalColors(\"#66cc66\", \"#E7E658\", \"#cc6666\"));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
