/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.ui.context;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.menuitem.MenuItem;
import org.dussan.vaadin.dmenu.menuitem.MenuItemElement;
import org.vaadin.aceeditor.AceEditor;
import org.vaadin.aceeditor.AceMode;
import org.vaadin.aceeditor.AceTheme;

import com.vaadin.ui.ComboBox;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;

public abstract class MenuContext
    extends VerticalLayout
{

    private static final long serialVersionUID = 7447580571029014661L;

    private static final String MENU_TOP_CODE_BOTTOM = "<table style='height:100%; width:100%;'>" //
        + "<tr><td style='height:1px;'><div location='menu'></div></td></tr>" //
        + "<tr><td style='height:100%;'><div style='height:100%;' location='code'></div></td></tr>" //
        + "</table>";

    private static final String CODE_TOP_MENU_BOTTOM = "<table style='height:100%; width:100%'>" //
        + "<tr><td style='height:100%;'><div style='height:100%;' location='code'></div></td></tr>" //
        + "<tr><td style='height:1px;'><div location='menu'></div></td></tr>" //
        + "</table>";

    private static final String MENU_TEXT = "\n\n"//
        + "Table table = new Table();\n"//
        + "table.setSizeFull();\n"//
        + "table.setPageLength( 3 );\n"//
        + "table.addContainerProperty( \"COL1\", String.class, null );\n"//
        + "table.addContainerProperty( \"COL2\", String.class, null );\n"//
        + "table.addContainerProperty( \"COL3\", String.class, null );\n"//
        + "table.addContainerProperty( \"COL4\", String.class, null );\n"//
        + "table.addItem( new Object[] { \"11\", \"12\", \"13\", \"14\" }, null );\n"//
        + "table.addItem( new Object[] { \"21\", \"22\", \"23\", \"24\" }, null );\n"//
        + "table.addItem( new Object[] { \"31\", \"32\", \"33\", \"34\" }, null );\n"//
        + "table.addItem( new Object[] { \"41\", \"42\", \"43\", \"44\" }, null );\n"//
        + "table.addItem( new Object[] { \"51\", \"52\", \"53\", \"54\" }, null );\n"//
        + "\n"//
        + "// MENU ITEM 1\n"//
        + "MenuItem item1 = new MenuItem( \"MENU 1\" );\n"//
        + "MenuItemElement itemElement10 = new MenuItemElement( null, table );\n"//
        + "MenuItemElement itemElement11 = new MenuItemElement( \"ELEMENT 11\", new Label( \"LABEL 11\" ) );\n"//
        + "MenuItemElement itemElement12 = new MenuItemElement( \"ELEMENT 12\", new Label( \"LABEL 12\" ) );\n"//
        + "MenuItemElement itemElement13 = new MenuItemElement( \"ELEMENT 13\", new Label( \"LABEL 13\" ) );\n"//
        + "OptionGroup group = new OptionGroup();\n"//
        + "group.addItem( \"One\" );\n"//
        + "group.addItem( \"Two\" );\n"//
        + "group.addItem( \"Three\" );\n"//
        + "group.setItemEnabled( \"Two\", false );\n"//
        + "MenuItemElement itemElement14 = new MenuItemElement( \"ELEMENT 14\", group );\n"//
        + "MenuItemElement itemElement15 = new MenuItemElement( \"ELEMENT 15\", new Label( \"LABEL 15\" ) );\n"//
        + "MenuItemElement itemElement16 = new MenuItemElement( \"ELEMENT 16\", new Label( \"LABEL 16\" ) );\n"//
        + "MenuItemElement itemElement17 = new MenuItemElement( \"ELEMENT 17\", new Label( \"LABEL 17\" ) );\n"//
        + "MenuItemElement itemElement18 = new MenuItemElement( \"ELEMENT 18\", new Label( \"LABEL 18\" ) );\n"//
        + "item1.addMenuItemElements( itemElement10, itemElement11, itemElement12, itemElement13, itemElement14,\n"//
        + "\t\t\t\t\t\t   itemElement15, itemElement16, itemElement17, itemElement18 );\n"//
        + "menu.addMenuItem( item1 );\n"//
        + "\n"//
        + "// MENU ITEM 2\n"//
        + "MenuItem item2 = new MenuItem( \"MENU 2\" );\n"//
        + "MenuItemElement itemElement21 = new MenuItemElement( \"ELEMENT 21\", new Label( \"LABEL 21\" ) );\n"//
        + "MenuItemElement itemElement22 = new MenuItemElement( \"ELEMENT 22\", new Label( \"LABEL 22\" ) );\n"//
        + "MenuItemElement itemElement23 = new MenuItemElement( \"ELEMENT 23\", new Label( \"LABEL 23\" ) );\n"//
        + "item2.addMenuItemElements( itemElement21, itemElement22, itemElement23 );\n"//
        + "menu.addMenuItem( item2 );\n"//
        + "\n"//
        + "// MENU ITEM 3\n"//
        + "MenuItem item3 = new MenuItem( \"MENU 3\" );\n"//
        + "ListSelect list = new ListSelect();\n"//
        + "list.addItems( \"Mercury 1\", \"Venus 1\", \"Earth 1\", \"Dušan 1\", \"Andreja 1\" );\n"//
        + "list.setNullSelectionAllowed( false );\n"//
        + "list.setRows( 5 );\n"//
        + "list.setSizeFull();\n"//
        + "ComboBox combo = new ComboBox();\n"//
        + "combo.addItems( \"Mercury 2 \", \"Venus 2\", \"Earth 2\", \"Dušan 2\", \"Andreja 2\" );\n"//
        + "combo.setNullSelectionAllowed( false );\n"//
        + "combo.setValue( \"Mercury 2\" );\n"//
        + "combo.setSizeUndefined();\n"//
        + "VerticalLayout verticalLayout = new VerticalLayout();\n"//
        + "verticalLayout.addComponent( combo );\n"//
        + "verticalLayout.addComponent( list );\n"//
        + "MenuItemElement itemElement31 = new MenuItemElement( \"ELEMENT 31\", new Label( \"LABEL 31\" ) );\n"//
        + "MenuItemElement itemElement32 = new MenuItemElement( \"ELEMENT 32\", verticalLayout );\n"//
        + "MenuItemElement itemElement33 = new MenuItemElement( \"ELEMENT 33\", new Label( \"LABEL 33\" ) );\n"//
        + "item3.addMenuItemElements( itemElement31, itemElement32, itemElement33 );\n"//
        + "menu.addMenuItem( item3 );\n";

    private static final String MENU_TEXT_SELECTED_TAB = "\n"//
        + "// MENU ITEM SELECTED PROGRAMMATICALLY\n"//
        + "menu.setSelectedMenuItem( {0} );\n";

    private boolean isAttached = false;

    public MenuContext()
    {
        setSizeFull();
        setSpacing( true );
        setStyleName( "menuCode" );
    }

    private void initMenu( DMenu menu, int selectedMenu )
    {
        Table table = new Table();
        table.setSizeFull();
        table.setPageLength( 3 );
        table.addContainerProperty( "COL1", String.class, null );
        table.addContainerProperty( "COL2", String.class, null );
        table.addContainerProperty( "COL3", String.class, null );
        table.addContainerProperty( "COL4", String.class, null );
        table.addItem( new Object[] { "11", "12", "13", "14" }, null );
        table.addItem( new Object[] { "21", "22", "23", "24" }, null );
        table.addItem( new Object[] { "31", "32", "33", "34" }, null );
        table.addItem( new Object[] { "41", "42", "43", "44" }, null );
        table.addItem( new Object[] { "51", "52", "53", "54" }, null );

        MenuItem item1 = new MenuItem( "MENU 1" );
        MenuItemElement itemElement10 = new MenuItemElement( null, table );
        MenuItemElement itemElement11 = new MenuItemElement( "ELEMENT 11", new Label( "LABEL 11" ) );
        MenuItemElement itemElement12 = new MenuItemElement( "ELEMENT 12", new Label( "LABEL 12" ) );
        MenuItemElement itemElement13 = new MenuItemElement( "ELEMENT 13", new Label( "LABEL 13" ) );
        OptionGroup group = new OptionGroup();
        group.addItem( "One" );
        group.addItem( "Two" );
        group.addItem( "Three" );
        group.setItemEnabled( "Two", false );
        group.setValue( "One" );
        MenuItemElement itemElement14 = new MenuItemElement( "ELEMENT 14", group );
        MenuItemElement itemElement15 = new MenuItemElement( "ELEMENT 15", new Label( "LABEL 15" ) );
        MenuItemElement itemElement16 = new MenuItemElement( "ELEMENT 16", new Label( "LABEL 16" ) );
        MenuItemElement itemElement17 = new MenuItemElement( "ELEMENT 17", new Label( "LABEL 17" ) );
        MenuItemElement itemElement18 = new MenuItemElement( "ELEMENT 18", new Label( "LABEL 18" ) );
        item1.addMenuItemElements( itemElement10, itemElement11, itemElement12, itemElement13, itemElement14,
                                   itemElement15, itemElement16, itemElement17, itemElement18 );
        menu.addMenuItem( item1 );

        MenuItem item2 = new MenuItem( "MENU 2" );
        MenuItemElement itemElement21 = new MenuItemElement( "ELEMENT 21", new Label( "LABEL 21" ) );
        MenuItemElement itemElement22 = new MenuItemElement( "ELEMENT 22", new Label( "LABEL 22" ) );
        MenuItemElement itemElement23 = new MenuItemElement( "ELEMENT 23", new Label( "LABEL 23" ) );
        item2.addMenuItemElements( itemElement21, itemElement22, itemElement23 );
        menu.addMenuItem( item2 );

        MenuItem item3 = new MenuItem( "MENU 3" );
        ListSelect list = new ListSelect();
        list.addItems( "Mercury 1", "Venus 1", "Earth 1", "Dušan 1", "Andreja 1" );
        list.setNullSelectionAllowed( false );
        list.setRows( 5 );
        list.setSizeFull();
        list.select( "Mercury 1" );
        ComboBox combo = new ComboBox();
        combo.addItems( "Mercury 2 ", "Venus 2", "Earth 2", "Dušan 2", "Andreja 2" );
        combo.setNullSelectionAllowed( false );
        combo.setSizeUndefined();
        combo.select( "Mercury 2 " );
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent( combo );
        verticalLayout.addComponent( list );
        MenuItemElement itemElement31 = new MenuItemElement( "ELEMENT 31", new Label( "LABEL 31" ) );
        MenuItemElement itemElement32 =
            new MenuItemElement( "ELEMENT 32 testing testing testing testing", verticalLayout );
        MenuItemElement itemElement33 = new MenuItemElement( "ELEMENT 33", new Label( "LABEL 33" ) );
        item3.addMenuItemElements( itemElement31, itemElement32, itemElement33 );
        menu.addMenuItem( item3 );

        menu.setSelectedMenuItem( selectedMenu );
    }

    protected abstract void init();

    protected void setMenu( DMenu menu, String text, boolean menuIsOnTop, int selectedMenu )
    {
        Panel code = new Panel( "Code for dMenu Demo" );
        AceEditor editor = new AceEditor();
        if ( selectedMenu != 0 )
        {
            editor.setValue( text + MENU_TEXT + MessageFormat.format( MENU_TEXT_SELECTED_TAB, selectedMenu ) );
        }
        else
        {
            editor.setValue( text + MENU_TEXT );
        }
        editor.setSizeFull();
        editor.setMode( AceMode.java );
        editor.setTheme( AceTheme.eclipse );
        editor.setReadOnly( true );
        code.setContent( editor );
        code.setSizeFull();
        initMenu( menu, selectedMenu );

        try
        {
            CustomLayout customLayout = null;
            if ( menuIsOnTop )
            {
                customLayout = new CustomLayout( new ByteArrayInputStream( MENU_TOP_CODE_BOTTOM.getBytes() ) );
            }
            else
            {
                customLayout = new CustomLayout( new ByteArrayInputStream( CODE_TOP_MENU_BOTTOM.getBytes() ) );
            }
            customLayout.setSizeFull();
            customLayout.addComponent( menu, "menu" );
            customLayout.addComponent( code, "code" );
            addComponent( customLayout );
        }
        catch ( IOException e )
        {
            Logger.getLogger( MenuContext.class.getName() )
                  .log( Level.WARNING, e.getLocalizedMessage() );
        }
    }

    @Override
    public void attach()
    {
        super.attach();
        if ( !isAttached )
        {
            isAttached = true;
            init();
            getParent().setSizeFull();
        }
    }

}
