/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.vaadin.dmenu.demo.menu.advanced.ItemAutoShow;
import org.dussan.vaadin.dmenu.demo.menu.advanced.ItemElementClickEvent;
import org.dussan.vaadin.dmenu.demo.menu.advanced.ItemsNotSameHeight;
import org.dussan.vaadin.dmenu.demo.menu.advanced.TabSelectProgrammatically;
import org.dussan.vaadin.dmenu.demo.menu.advanced.TabsAutoChange;
import org.dussan.vaadin.dmenu.demo.menu.advanced.TabsChangeEvent;
import org.dussan.vaadin.dmenu.demo.menu.summary.MenuSummary;
import org.dussan.vaadin.dmenu.demo.menu.types.AdvancedMenuTypes;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTree;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class AdvancedMenus
{
    private AdvancedMenus()
    {
        // Auto-generated constructor stub
    }

    public static void addMenu( final Tree tree )
    {
        String parent = AdvancedMenuTypes.values()[0].getPath();
        tree.addItem( parent );
        tree.setItemCaption( parent, AdvancedMenuTypes.values()[0].getDescription() );
        for ( int menu = 1; menu < AdvancedMenuTypes.values().length; menu++ )
        {
            String item = parent + MenuTree.PATH_DELIMITER + AdvancedMenuTypes.values()[menu].getPath();
            String itemValue = AdvancedMenuTypes.values()[menu].getDescription();
            tree.addItem( item );
            tree.setItemCaption( item, itemValue );
            tree.setParent( item, parent );
            tree.setChildrenAllowed( item, false );
        }
        tree.expandItemsRecursively( parent );
    }

    public static Component processMenu( String menu )
    {
        Component component = null;
        switch ( AdvancedMenuTypes.fromString( menu ) )
        {
            case ITEM_AUTO_SHOW:
                component = new ItemAutoShow();
                break;
            case ITEM_ELEMENT_CLICK_EVENT:
                component = new ItemElementClickEvent();
                break;
            case ITEM_NOT_SAME_HEIGHT:
                component = new ItemsNotSameHeight();
                break;
            case TABS_AUTO_CHANGE:
                component = new TabsAutoChange();
                break;
            case TABS_CHANGE_EVENT:
                component = new TabsChangeEvent();
                break;
            case TAB_SELECT_PROGRAMMATICALLY:
                component = new TabSelectProgrammatically();
                break;
            case DEFAULT:
            default:
                Map<String, Map<String, String[]>> menus = new LinkedHashMap<>();
                menus.put( MenuTypes.ADVANCED.getPath(), getMenus() );
                component = new MenuSummary( menus );
                break;
        }
        return component;
    }

    public static Map<String, String[]> getMenus()
    {
        Map<String, String[]> menus = new LinkedHashMap<>();
        for ( AdvancedMenuTypes menu : AdvancedMenuTypes.values() )
        {
            menus.put( menu.getPath(), new String[] { menu.getDescription(), menu.getLongDescription() } );
        }
        return menus;
    }

}
