/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.vaadin.dmenu.demo.api.MenuType;

public enum AdvancedMenuTypes
    implements MenuType
{

    // definition: menu type, menu, is new
    DEFAULT( "advancedMenus", "Advanced menus", "Advanced menus", false ), //
    TABS_AUTO_CHANGE( "tabsAutoChange", "Menu tabs auto change", "Menu tabs auto change", false ), //
    ITEM_AUTO_SHOW( "itemAutoShow", "Floating menu item auto show", "Floating menu item auto show", false ), //
    ITEM_NOT_SAME_HEIGHT( "itemsNotSameHeight", "Menu items not same height", "Menu items not same height", false ), //
    TAB_SELECT_PROGRAMMATICALLY( "tabSelectProgrammatically", "Select tab programmatically",
        "Select tab programmatically", false ), //
    TABS_CHANGE_EVENT( "tabsChangeEvent", "Menu tabs change event", "Menu tabs change event", true ), //
    ITEM_ELEMENT_CLICK_EVENT( "itemElementClickEvent", "Menu item element click event", "Menu item element click event",
        true );

    private final transient List<Object> menu;

    private AdvancedMenuTypes( Object... menus )
    {
        menu = Arrays.asList( menus );
    }

    private List<Object> getValues()
    {
        return menu;
    }

    public static AdvancedMenuTypes fromString( String menu )
    {
        if ( menu != null )
        {
            for ( AdvancedMenuTypes tempMenu : AdvancedMenuTypes.values() )
            {
                if ( tempMenu.getValues()
                             .contains( menu ) )
                {
                    return tempMenu;
                }
            }
        }
        return DEFAULT;
    }

    @Override
    public String getPath()
    {
        return menu.get( 0 )
                   .toString();
    }

    @Override
    public String getDescription()
    {
        return menu.get( 1 )
                   .toString();
    }

    @Override
    public String getLongDescription()
    {
        return menu.get( 2 )
                   .toString();
    }

    @Override
    public boolean isNew()
    {
        return Boolean.parseBoolean( menu.get( 3 )
                                         .toString() );
    }

    @Override
    public String toString()
    {
        return getPath();
    }

}
