/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.vaadin.dmenu.demo.menu.basic.Basic;
import org.dussan.vaadin.dmenu.demo.menu.basic.BasicBottom;
import org.dussan.vaadin.dmenu.demo.menu.basic.FloatingBottom;
import org.dussan.vaadin.dmenu.demo.menu.basic.Floating;
import org.dussan.vaadin.dmenu.demo.menu.summary.MenuSummary;
import org.dussan.vaadin.dmenu.demo.menu.types.BasicMenuTypes;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTree;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class BasicMenus
{

    private BasicMenus()
    {
        // Auto-generated constructor stub
    }

    public static void addMenu( final Tree tree )
    {
        String parent = BasicMenuTypes.values()[0].getPath();
        tree.addItem( parent );
        tree.setItemCaption( parent, BasicMenuTypes.values()[0].getDescription() );
        for ( int menu = 1; menu < BasicMenuTypes.values().length; menu++ )
        {
            String item = parent + MenuTree.PATH_DELIMITER + BasicMenuTypes.values()[menu].getPath();
            String itemValue = BasicMenuTypes.values()[menu].getDescription();
            tree.addItem( item );
            tree.setItemCaption( item, itemValue );
            tree.setParent( item, parent );
            tree.setChildrenAllowed( item, false );
        }
        tree.expandItemsRecursively( parent );
    }

    public static Component processMenu( String menu )
    {
        Component component = null;
        switch ( BasicMenuTypes.fromString( menu ) )
        {
            case BASIC:
                component = new Basic();
                break;
            case BASIC_BOTTOM:
                component = new BasicBottom();
                break;
            case FLOATING:
                component = new Floating();
                break;
            case FLOATING_BOTTOM:
                component = new FloatingBottom();
                break;
            case DEFAULT:
            default:
                Map<String, Map<String, String[]>> menus = new LinkedHashMap<>();
                menus.put( MenuTypes.BASIC.getPath(), getMenus() );
                component = new MenuSummary( menus );
                break;
        }
        return component;
    }

    public static Map<String, String[]> getMenus()
    {
        Map<String, String[]> menus = new LinkedHashMap<>();
        for ( BasicMenuTypes menu : BasicMenuTypes.values() )
        {
            menus.put( menu.getPath(), new String[] { menu.getDescription(), menu.getLongDescription() } );
        }
        return menus;
    }

}
