/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu.summary;

import java.util.Map;
import java.util.Map.Entry;

import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTree;

import com.vaadin.event.MouseEvents.ClickEvent;
import com.vaadin.event.MouseEvents.ClickListener;
import com.vaadin.server.Page;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;

public class MenuSummary
    extends VerticalLayout
{

    private static final long serialVersionUID = 3820400646479836281L;

    private boolean isAttached = false;

    private Map<String, Map<String, String[]>> tabs = null;

    public MenuSummary( Map<String, Map<String, String[]>> tabs )
    {
        this.tabs = tabs;
    }

    private void init()
    {
        setSizeUndefined();
        setWidth( 100, Unit.PERCENTAGE );

        for ( Entry<String, Map<String, String[]>> tab : tabs.entrySet() )
        {
            String menuType = tab.getKey();
            Map<String, String[]> tempMenus = tab.getValue();

            VerticalLayout menusLayout = new VerticalLayout();
            menusLayout.setSizeUndefined();
            menusLayout.setWidth( 100, Unit.PERCENTAGE );
            menusLayout.setStyleName( "menusLayout" );
            addComponent( menusLayout );

            Label menuTypeLabel = new Label();
            menuTypeLabel.setWidth( 100, Unit.PERCENTAGE );
            menuTypeLabel.setStyleName( "menuTypeLabel" );
            menusLayout.addComponent( menuTypeLabel );

            CssLayout cssLayout = new CssLayout();
            cssLayout.setSizeUndefined();
            cssLayout.setWidth( 100, Unit.PERCENTAGE );
            menusLayout.addComponent( cssLayout );

            for ( Entry<String, String[]> tempMenu : tempMenus.entrySet() )
            {
                String menuName = tempMenu.getKey();
                String menuDescription = tempMenu.getValue()[0];
                String menuLongDescription = tempMenu.getValue()[1];
                if ( menuType.equals( menuName ) )
                {
                    menuTypeLabel.setValue( menuDescription );
                }
                else
                {
                    VerticalLayout menuLayout = new VerticalLayout();
                    menuLayout.setSizeUndefined();
                    menuLayout.setStyleName( "menuLayout" );
                    cssLayout.addComponent( menuLayout );

                    Embedded menuImage =
                        new Embedded( null, new ThemeResource( "images/" + menuType + "/" + menuName + ".png" ) );
                    menuImage.setStyleName( "menuImage" );
                    menuImage.setId( menuType + "/" + menuName );
                    menuLayout.addComponent( menuImage );

                    Label menuLabel = new Label( menuLongDescription );
                    menuLabel.setStyleName( "menuLabel" );
                    if ( MenuTree.isNewMenu( menuType, menuName ) )
                    {
                        menuLabel.setContentMode( ContentMode.HTML );
                        menuLabel.setValue( "<span class='new-menu'>" + menuLongDescription + "</span>" );
                    }
                    menuLayout.addComponent( menuLabel );
                    menuImage.addClickListener( new ClickListener()
                    {
                        private static final long serialVersionUID = 301424711026984913L;

                        @Override
                        public void click( ClickEvent event )
                        {
                            String fragment = event.getComponent()
                                                   .getId();
                            Page.getCurrent()
                                .setUriFragment( fragment );
                        }
                    } );
                }
            }
        }
    }

    @Override
    public void attach()
    {
        if ( !isAttached )
        {
            isAttached = true;
            super.attach();
            init();
        }
    }

    @Override
    public void detach()
    {
        if ( isAttached )
        {
            isAttached = false;
            super.detach();
        }
    }

}
