/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.vaadin.dmenu.demo.api.MenuType;

public enum BasicMenuTypes
    implements MenuType
{

    // definition: menu type, menu, is new
    DEFAULT( "basicMenus", "Basic menus", "Basic menus", false ), //
    BASIC( "basic", "Basic menu", "Basic menu", false ), //
    BASIC_BOTTOM( "basicBottom", "Basic menu placed bottom", "Basic menu placed bottom", false ), //
    FLOATING( "floating", "Floating menu", "Floating menu", false ), //
    FLOATING_BOTTOM( "floatingBottom", "Floating menu placed bottom", "Floating menu placed bottom", false );

    private final transient List<Object> menu;

    private BasicMenuTypes( Object... menu )
    {
        this.menu = Arrays.asList( menu );
    }

    private List<Object> getValues()
    {
        return menu;
    }

    public static BasicMenuTypes fromString( String menu )
    {
        if ( menu != null )
        {
            for ( BasicMenuTypes tempMenu : BasicMenuTypes.values() )
            {
                if ( tempMenu.getValues()
                             .contains( menu ) )
                {
                    return tempMenu;
                }
            }
        }
        return DEFAULT;
    }

    @Override
    public String getPath()
    {
        return menu.get( 0 )
                   .toString();
    }

    @Override
    public String getDescription()
    {
        return menu.get( 1 )
                   .toString();
    }

    @Override
    public String getLongDescription()
    {
        return menu.get( 2 )
                   .toString();
    }

    @Override
    public boolean isNew()
    {
        return Boolean.parseBoolean( menu.get( 3 )
                                         .toString() );
    }

    @Override
    public String toString()
    {
        return getPath();
    }

}
