/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.ui.context;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.vaadin.dmenu.demo.menu.BasicMenus;
import org.dussan.vaadin.dmenu.demo.menu.AdvancedMenus;
import org.dussan.vaadin.dmenu.demo.menu.summary.MenuSummary;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTypes;
import org.dussan.vaadin.dmenu.demo.ui.tree.MenuTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;

public class ContextLayout
    extends VerticalLayout
{

    private static final long serialVersionUID = 682225016379675172L;

    private boolean isAttached = false;

    private Component activeComponent = null;

    private void init()
    {
        setStyleName( "menuContext" );
        setMargin( true );
        activeComponent = new MenuSummary( addMenu() );
        addComponent( activeComponent );
    }

    private void replaceActiveComponent( Component newComponent )
    {
        if ( !activeComponent.equals( newComponent ) )
        {
            removeComponent( activeComponent );
            activeComponent = newComponent;
            addComponent( activeComponent );
        }
    }

    private Map<String, Map<String, String[]>> addMenu()
    {
        Map<String, Map<String, String[]>> menu = new LinkedHashMap<>();
        menu.put( MenuTypes.BASIC.getPath(), BasicMenus.getMenus() );
        menu.put( MenuTypes.ADVANCED.getPath(), AdvancedMenus.getMenus() );
        return menu;
    }

    public void processChangedFragment( String fragment )
    {
        String menuType = fragment.isEmpty() ? fragment : fragment.split( MenuTree.PATH_DELIMITER )[0];
        String menu = ( !fragment.isEmpty() && fragment.contains( MenuTree.PATH_DELIMITER ) )
                        ? fragment.split( MenuTree.PATH_DELIMITER )[1] : new String();

        Component tempComponent = null;
        switch ( MenuTypes.fromString( menuType ) )
        {
            case ADVANCED:
                tempComponent = AdvancedMenus.processMenu( menu );
                break;
            case BASIC:
                tempComponent = BasicMenus.processMenu( menu );
                break;
            case DEFAULT:
            default:
                tempComponent = new MenuSummary( addMenu() );
                break;
        }
        replaceActiveComponent( tempComponent );
    }

    @Override
    public void attach()
    {
        super.attach();
        if ( !isAttached )
        {
            isAttached = true;
            init();
        }
    }

    @Override
    public void detach()
    {
        super.detach();
        if ( isAttached )
        {
            isAttached = false;
        }
    }

}
