/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.ui.tree;

import java.util.Arrays;
import java.util.List;

import org.dussan.vaadin.dmenu.demo.menu.types.BasicMenuTypes;
import org.dussan.vaadin.dmenu.demo.menu.types.AdvancedMenuTypes;

public enum MenuTypes
{

    DEFAULT( "", "" ), //
    ADVANCED( AdvancedMenuTypes.DEFAULT.getPath(), AdvancedMenuTypes.DEFAULT.getDescription() ), //
    BASIC( BasicMenuTypes.DEFAULT.getPath(), BasicMenuTypes.DEFAULT.getDescription() );

    private final List<String> menu;

    private MenuTypes( String... menu )
    {
        this.menu = Arrays.asList( menu );
    }

    private List<String> getValues()
    {
        return menu;
    }

    public String getPath()
    {
        return menu.get( 0 );
    }

    public String getDescription()
    {
        return menu.get( 1 );
    }

    public static MenuTypes fromString( String menu )
    {
        if ( menu != null )
        {
            for ( MenuTypes tempMenu : MenuTypes.values() )
            {
                if ( tempMenu.getValues()
                             .contains( menu ) )
                {
                    return tempMenu;
                }
            }
        }
        return null;
    }

    @Override
    public String toString()
    {
        return getPath();
    }

}
