/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu.advanced;

import java.text.MessageFormat;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.demo.ui.context.MenuContext;
import org.dussan.vaadin.dmenu.events.MenuItemChangeEvent;
import org.dussan.vaadin.dmenu.events.MenuItemChangeHandler;

import com.vaadin.server.Page;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Notification.Type;

public class TabsChangeEvent
    extends MenuContext
{

    private static final long serialVersionUID = -564063887969830308L;

    private static final String MENU_ITEM_CHANGE = "Menu item change";

    private static final String ACTIVE_TAB = "Active tab: {0}";

    @Override
    protected void init()
    {
        DMenu menu = new DMenu();
        menu.setTabBarBottom( false )
            .setCenteredTabs( true );
        menu.setFloatingMenu( false );
        menu.setFloatingMenuItemAutoHide( false );
        menu.setFloatingMenuItemAutoShow( false );
        menu.setMenuItemsSameHeight( true );
        menu.setMenuItemElementsSameHeight( true );
        menu.addHandler( new MenuItemChangeHandler()
        {
            @Override
            public void onMenuItemChange( MenuItemChangeEvent event )
            {
                new Notification( MENU_ITEM_CHANGE, MessageFormat.format( ACTIVE_TAB, event.getMenuItem()
                                                                                           .getCaption() ),
                                  Type.WARNING_MESSAGE, true ).show( Page.getCurrent() );
            }
        } );

        setMenu( menu,
                 "DMenu menu = new DMenu();\n"//
                     + "menu.setCenteredTabs( true );\n"//
                     + "menu.setMenuItemsSameHeight( true );\n"//
                     + "menu.setMenuItemElementsSameHeight( true );\n"//
                     + "menu.addHandler( new MenuItemChangeHandler()\n"//
                     + "{\n"//
                     + "\t@Override\n"//
                     + "\tpublic void onMenuItemChange( MenuItemChangeEvent event )\n"//
                     + "\t{\n"//
                     + "\t\tnew Notification( \"Menu item change\", \"Active tab: \" + event.getMenuItem()\n"//
                     + "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t.getCaption() ),\n"//
                     + "\t\t\t\t\t\t  Type.WARNING_MESSAGE, true ).show( Page.getCurrent() );\n"//
                     + "\t}\n"//
                     + "} );",
                 true, 0 );
    }

}
