/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.demo.menu.basic;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.demo.ui.context.MenuContext;

public class FloatingBottom
    extends MenuContext
{

    private static final long serialVersionUID = -5580491298963562690L;

    @Override
    protected void init()
    {
        DMenu menu = new DMenu();
        menu.setTabBarBottom( true )
            .setCenteredTabs( true );
        menu.setMenuTabsAutoChange( false );
        menu.setFloatingMenu( true );
        menu.setFloatingMenuItemAutoHide( false );
        menu.setFloatingMenuItemAutoShow( false );
        menu.setMenuItemsSameHeight( true );
        menu.setMenuItemElementsSameHeight( true );

        setMenu( menu,
                 "DMenu menu = new DMenu();\n"//
                     + "menu.setTabBarBottom( true );\n"//
                     + "menu.setCenteredTabs( true );\n"//
                     + "menu.setFloatingMenu( true );\n"//
                     + "menu.setMenuItemsSameHeight( true );\n"//
                     + "menu.setMenuItemElementsSameHeight( true );",
                 false, 0 );
    }

}
