/**
 * Copyright (C) 2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.elements;

import static com.google.gwt.query.client.GQuery.$;

import org.dussan.vaadin.dmenu.client.VDMenu;

import com.google.gwt.dom.client.Element;
import com.google.gwt.query.client.GQuery;

public class MenuTabs {

	private int tabsWidth = 0;
	private GQuery tabs = null;
	private GQuery activeTab;
	private GQuery tabLeftButton = null;
	private GQuery tabRightButton = null;

	public MenuTabs(String menuId) {
		tabs = $(VDMenu.TAB, $(VDMenu.ID(menuId + VDMenu.TAB_ID)).get(0));
		activeTab = $(tabs).filter(VDMenu.CLASS(VDMenu.TAB_ACTIVE));
		activateButtons();

		// calculate all tabs width
		tabsWidth = 0;
		for (Element tab : tabs.elements()) {
			tabsWidth += $(tab).outerWidth(true);
		}
	}

	private void activateButtons() {
		tabLeftButton = $(VDMenu.EMPTY_DIV).html(VDMenu.EMPTY_HTML)
				.id(VDMenu.TAB_BUTTON_LEFT_ID)
				.addClass(VDMenu.TAB_BUTTON_LEFT_ACTIVE);
		tabRightButton = $(VDMenu.EMPTY_DIV).html(VDMenu.EMPTY_HTML)
				.id(VDMenu.TAB_BUTTON_RIGHT_ID)
				.addClass(VDMenu.TAB_BUTTON_RIGHT_ACTIVE);

		GQuery tabsContainer = tabs.parent();
		String clazz = tabsContainer.attr(VDMenu.CLASS);
		if (clazz.endsWith(VDMenu.TOP + VDMenu.LEFT)) {
			tabsContainer.append($(VDMenu.EMPTY_DIV)
					.addClass(VDMenu.TAB_BUTTON_TOP_RIGHT)
					.append(tabLeftButton).append(tabRightButton));
		} else if (clazz.endsWith(VDMenu.TOP + VDMenu.RIGHT)) {
			tabsContainer.prepend($(VDMenu.EMPTY_DIV)
					.addClass(VDMenu.TAB_BUTTON_TOP_LEFT).append(tabLeftButton)
					.append(tabRightButton));
		} else if (clazz.endsWith(VDMenu.TOP + VDMenu.CENTER)) {
			tabsContainer.prepend(
					$(VDMenu.EMPTY_DIV).addClass(VDMenu.TAB_BUTTON_TOP_LEFT)
							.append(tabLeftButton)).append(
					$(VDMenu.EMPTY_DIV).addClass(VDMenu.TAB_BUTTON_TOP_RIGHT)
							.append(tabRightButton));
		} else if (clazz.endsWith(VDMenu.BOTTOM + VDMenu.LEFT)) {
			tabsContainer.append($(VDMenu.EMPTY_DIV)
					.addClass(VDMenu.TAB_BUTTON_BOTTOM_RIGHT)
					.append(tabLeftButton).append(tabRightButton));
		} else if (clazz.endsWith(VDMenu.BOTTOM + VDMenu.RIGHT)) {
			tabsContainer.prepend($(VDMenu.EMPTY_DIV)
					.addClass(VDMenu.TAB_BUTTON_BOTTOM_LEFT)
					.append(tabLeftButton).append(tabRightButton));
		} else if (clazz.endsWith(VDMenu.BOTTOM + VDMenu.CENTER)) {
			tabsContainer.prepend(
					$(VDMenu.EMPTY_DIV).addClass(VDMenu.TAB_BUTTON_BOTTOM_LEFT)
							.append(tabLeftButton)).append(
					$(VDMenu.EMPTY_DIV)
							.addClass(VDMenu.TAB_BUTTON_BOTTOM_RIGHT).append(
									tabRightButton));
		}
	}

	public GQuery getTabs() {
		return tabs;
	}

	public GQuery getTab(int tab) {
		return tabs.eq(tab);
	}

	public GQuery getActiveTab() {
		return activeTab;
	}

	public int getActiveTabNumber() {
		return Integer.parseInt(activeTab.id().substring(
				activeTab.id().length() - 1));
	}

	public String getTabItemId(int tab) {
		return tabs.eq(tab).id().replace(VDMenu.TAB_ID, VDMenu.ITEM_ID);
	}

	public boolean isActiveTab(GQuery tab) {
		return activeTab.id().equals(tab.id());
	}

	public void setActiveTab(GQuery tab) {
		activeTab.removeClass(VDMenu.TAB_ACTIVE);
		activeTab = tab.addClass(VDMenu.TAB_ACTIVE);
	}

	public String getTabsLocation() {
		String clazz = tabs.parent().attr(VDMenu.CLASS);
		return (clazz.contains(VDMenu.TOP) ? VDMenu.TAB_LOCATION_TOP
				: VDMenu.TAB_LOCATION_BOTTOM);
	}

	public void check(boolean fromLeft) {
		GQuery tabContainer = tabs.parent();
		if (tabsWidth < tabContainer.width()) {
			tabs.removeClass(VDMenu.HIDDEN);
			tabLeftButton.parent().addClass(VDMenu.HIDDEN);
			tabRightButton.parent().addClass(VDMenu.HIDDEN);
		} else {
			if (fromLeft) {
				int visibleTab = tabs.index($(VDMenu.TAB_VISIBLE,
						tabContainer.get(0)).first().get(0));
				tabs.addClass(VDMenu.HIDDEN);

				int tabsWidth = getTab(visibleTab).removeClass(VDMenu.HIDDEN)
						.outerWidth();
				for (int tab = visibleTab + 1; tab < tabs.size()
						&& (tabsWidth + getTab(tab).outerWidth(true)) < tabContainer
								.width(); tab++) {
					tabsWidth += getTab(tab).removeClass(VDMenu.HIDDEN)
							.outerWidth(true);
				}
			} else {
				int visibleTab = tabs.index($(VDMenu.TAB_VISIBLE,
						tabContainer.get(0)).last().get(0));
				tabs.addClass(VDMenu.HIDDEN);

				int tabsWidth = getTab(visibleTab).removeClass(VDMenu.HIDDEN)
						.outerWidth();
				for (int tab = visibleTab - 1; 0 <= tab
						&& (tabsWidth + getTab(tab).outerWidth(true)) < tabContainer
								.width(); tab--) {
					tabsWidth += getTab(tab).removeClass(VDMenu.HIDDEN)
							.outerWidth(true);
				}
			}

			// check tab buttons visibility
			tabLeftButton.parent().removeClass(VDMenu.HIDDEN);
			tabLeftButton.removeClass(VDMenu.TAB_BUTTON_LEFT_ACTIVE,
					VDMenu.TAB_BUTTON_LEFT_INACTIVE).addClass(
					tabs.first().isVisible() ? VDMenu.TAB_BUTTON_LEFT_INACTIVE
							: VDMenu.TAB_BUTTON_LEFT_ACTIVE);
			tabRightButton.parent().removeClass(VDMenu.HIDDEN);
			tabRightButton.removeClass(VDMenu.TAB_BUTTON_RIGHT_ACTIVE,
					VDMenu.TAB_BUTTON_RIGHT_INACTIVE).addClass(
					tabs.last().isVisible() ? VDMenu.TAB_BUTTON_RIGHT_INACTIVE
							: VDMenu.TAB_BUTTON_RIGHT_ACTIVE);
		}
	}

	public void goLeft() {
		$(VDMenu.TAB_VISIBLE, tabs.parent().get(0)).first().prev()
				.removeClass(VDMenu.HIDDEN);
		check(true);
	}

	public void goRight() {
		$(VDMenu.TAB_VISIBLE, tabs.parent().get(0)).last().next()
				.removeClass(VDMenu.HIDDEN);
		check(false);
	}

}
