/**
 * Copyright (C) 2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.events;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.vaadin.client.VConsole;

public class MenuEvents {

	public static final int ACTIONS_ARE_PROCESSED = 0;
	public static final int ACTIVE_TAB_EVENT = 1;
	public static final int FLOATING_MENU_EVENT = 2;
	public static final int FLOATING_ITEM_EVENT = 3;

	private static <T> void fire(HasValueChangeHandlers<T> source, T value) {
		try {
			ValueChangeEvent.fire(source, value);
		} catch (IndexOutOfBoundsException e) {
			VConsole.error("Failed to fire event for active tab.");
		}
	}

	@SuppressWarnings("unchecked")
	public static <T> void fireActionsAreProcessed(
			HasValueChangeHandlers<T> source) {
		fire(source, (T) new Object[] { ACTIONS_ARE_PROCESSED, true });
	}

	@SuppressWarnings("unchecked")
	public static <T> void fireActiveTabChange(
			HasValueChangeHandlers<T> source, int activeTab) {
		fire(source, (T) new Object[] { ACTIVE_TAB_EVENT, activeTab });
	}

	@SuppressWarnings("unchecked")
	public static <T> void fireFloatingMenuChange(
			HasValueChangeHandlers<T> source, boolean visible) {
		fire(source, (T) new Object[] { FLOATING_MENU_EVENT, visible });
	}

	@SuppressWarnings("unchecked")
	public static <T> void fireFloatingMenuItemChange(
			HasValueChangeHandlers<T> source, boolean visible) {
		fire(source, (T) new Object[] { FLOATING_ITEM_EVENT, visible });
	}

}
