/**
 * Copyright (C) 2013-2015  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.events;

import com.google.gwt.event.shared.GwtEvent;

public class ActiveTabChangeEvent extends GwtEvent<ActiveTabChangeHandler> {

	private int activeTab = -1;
	public static final Type<ActiveTabChangeHandler> TYPE = new Type<ActiveTabChangeHandler>();

	public ActiveTabChangeEvent(int activeTab) {
		this.activeTab = activeTab;
	}

	public int getActiveTab() {
		return activeTab;
	}

	@Override
	public Type<ActiveTabChangeHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ActiveTabChangeHandler handler) {
		handler.onActiveTabChange(this);
	}

	public static Type<ActiveTabChangeHandler> getType() {
		return TYPE;
	}

}
