/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.state;

import org.dussan.vaadin.dtabs.client.TabsState;

public class MenuState
    extends TabsState
{

    private static final long serialVersionUID = -7980416855595920235L;

    private boolean menuItemsSameHeight = false;

    private boolean menuItemsSameHeightDefined = false;

    private boolean menuItemElementsSameHeight = false;

    private boolean menuItemAutoChange = false;

    private boolean floatingMenu = false;

    private boolean floatingMenuLock = false;

    private boolean floatingMenuItemAutoHide = false;

    private boolean floatingMenuItemAutoShow = false;

    private String menuId = null;

    private int menuItemElementsCount = 0;

    private int selectedMenuItem = 0;

    public boolean isMenuItemsSameHeight()
    {
        return menuItemsSameHeight;
    }

    public void setMenuItemsSameHeight( boolean menuItemsSameHeight )
    {
        this.menuItemsSameHeight = menuItemsSameHeight;
    }

    public boolean isMenuItemsSameHeightDefined()
    {
        return menuItemsSameHeightDefined;
    }

    public void setMenuItemsSameHeightDefined( boolean menuItemsSameHeightDefined )
    {
        this.menuItemsSameHeightDefined = menuItemsSameHeightDefined;
    }

    public boolean isMenuItemElementsSameHeight()
    {
        return menuItemElementsSameHeight;
    }

    public void setMenuItemElementsSameHeight( boolean menuItemElementsSameHeight )
    {
        this.menuItemElementsSameHeight = menuItemElementsSameHeight;
    }

    public String getMenuId()
    {
        return menuId;
    }

    public void setMenuId( String menuId )
    {
        this.menuId = menuId;
    }

    public int getMenuItemElementsCount()
    {
        return menuItemElementsCount;
    }

    public void setMenuItemElementsCount( int menuItemElementsCount )
    {
        this.menuItemElementsCount = menuItemElementsCount;
    }

    public int getSelectedMenuItem()
    {
        return selectedMenuItem;
    }

    public void setSelectedMenuItem( int selectedMenuItem )
    {
        this.selectedMenuItem = selectedMenuItem;
    }

    public boolean isMenuItemAutoChange()
    {
        return menuItemAutoChange;
    }

    public void setMenuItemAutoChange( boolean menuItemAutoChange )
    {
        this.menuItemAutoChange = menuItemAutoChange;
    }

    public boolean isFloatingMenu()
    {
        return floatingMenu;
    }

    public void setFloatingMenu( boolean floatingMenu )
    {
        this.floatingMenu = floatingMenu;
    }

    public boolean isFloatingMenuLock()
    {
        return floatingMenuLock;
    }

    public void setFloatingMenuLock( boolean floatingMenuLock )
    {
        this.floatingMenuLock = floatingMenuLock;
    }

    public boolean isFloatingMenuItemAutoHide()
    {
        return floatingMenuItemAutoHide;
    }

    public void setFloatingMenuItemAutoHide( boolean floatingMenuItemAutoHide )
    {
        this.floatingMenuItemAutoHide = floatingMenuItemAutoHide;
    }

    public boolean isFloatingMenuItemAutoShow()
    {
        return floatingMenuItemAutoShow;
    }

    public void setFloatingMenuItemAutoShow( boolean floatingMenuItemAutoShow )
    {
        this.floatingMenuItemAutoShow = floatingMenuItemAutoShow;
    }

}
