/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.test;

import javax.servlet.annotation.WebServlet;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.menuitem.MenuItem;
import org.dussan.vaadin.dmenu.menuitem.MenuItemElement;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Label;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

@Theme( "dmenu-theme" )
@Title( "DMenu Add-on Test" )
@Widgetset( "org.dussan.vaadin.dmenu.WidgetSet" )
public class DMenuUI
    extends UI
{

    private static final long serialVersionUID = 1833595858297782412L;

    @Override
    protected void init( VaadinRequest vaadinRequest )
    {
        VerticalLayout view = new VerticalLayout();
        view.setSizeFull();
        view.setHeightUndefined();
        setContent( view );

        DMenu menu1 = getMenu();
        menu1.setSelectedTab( 1 );
        view.addComponent( menu1 );

        view.addComponent( new VerticalLayout() );
        
        DMenu menu2 = getMenu();
        menu2.setTabBarBottom( true );
        menu2.setFloatingMenu( true );
        menu2.setSelectedTab( 3 );
        view.addComponent( menu2 );
    }

    private DMenu getMenu()
    {
        DMenu menu = new DMenu();
        menu.setTabBarBottom( false )
            .setCenteredTabs( true );
        menu.setMenuTabsAutoChange( false );
        menu.setFloatingMenu( false );
        menu.setFloatingMenuItemAutoHide( false );
        menu.setFloatingMenuItemAutoShow( false );
        menu.setMenuItemsSameHeight( true );
        menu.setMenuItemElementsSameHeight( true );

        Table table = new Table();
        table.setSizeFull();
        table.setPageLength( 3 );
        table.addContainerProperty( "COL1", String.class, null );
        table.addContainerProperty( "COL2", String.class, null );
        table.addContainerProperty( "COL3", String.class, null );
        table.addContainerProperty( "COL4", String.class, null );
        table.addItem( new Object[] { "1", "1", "1", "1" }, null );
        table.addItem( new Object[] { "2", "2", "2", "2" }, null );
        table.addItem( new Object[] { "3", "3", "3", "3" }, null );
        table.addItem( new Object[] { "4", "4", "4", "4" }, null );
        table.addItem( new Object[] { "5", "5", "5", "5" }, null );

        MenuItem item1 = new MenuItem( "TAB 1 (testing)" );
        MenuItemElement itemElement10 = new MenuItemElement( null, table );
        MenuItemElement itemElement11 = new MenuItemElement( "ELEMENT 11", new Label( "LABEL 11" ) );
        MenuItemElement itemElement12 = new MenuItemElement( "ELEMENT 12", new Label( "LABEL 12" ) );
        MenuItemElement itemElement13 = new MenuItemElement( "ELEMENT 13", new Label( "LABEL 13" ) );
        OptionGroup group = new OptionGroup();
        group.addItem( "One" );
        group.addItem( "Two" );
        group.addItem( "Three" );
        group.setItemEnabled( "Two", false );
        MenuItemElement itemElement14 = new MenuItemElement( "ELEMENT 14", group );
        MenuItemElement itemElement15 = new MenuItemElement( "ELEMENT 15", new Label( "LABEL 15" ) );
        MenuItemElement itemElement16 = new MenuItemElement( "ELEMENT 16", new Label( "LABEL 16" ) );
        MenuItemElement itemElement17 = new MenuItemElement( "ELEMENT 17", new Label( "LABEL 17" ) );
        MenuItemElement itemElement18 = new MenuItemElement( "ELEMENT 18", new Label( "LABEL 18" ) );
        MenuItemElement itemElement19 = new MenuItemElement( "ELEMENT 19", new Label( "LABEL 19" ) );
        MenuItemElement itemElement110 = new MenuItemElement( "ELEMENT 110", new Label( "LABEL 110" ) );
        MenuItemElement itemElement111 = new MenuItemElement( "ELEMENT 111", new Label( "LABEL 111" ) );
        MenuItemElement itemElement112 = new MenuItemElement( "ELEMENT 112", new Label( "LABEL 112" ) );
        MenuItemElement itemElement113 = new MenuItemElement( "ELEMENT 113", new Label( "LABEL 113" ) );
        MenuItemElement itemElement114 = new MenuItemElement( "ELEMENT 114", new Label( "LABEL 114" ) );
        MenuItemElement itemElement115 = new MenuItemElement( "ELEMENT 115", new Label( "LABEL 115" ) );
        MenuItemElement itemElement116 = new MenuItemElement( "ELEMENT 116", new Label( "LABEL 116" ) );
        MenuItemElement itemElement117 = new MenuItemElement( "ELEMENT 117", new Label( "LABEL 117" ) );
        MenuItemElement itemElement118 = new MenuItemElement( "ELEMENT 118", new Label( "LABEL 118" ) );
        MenuItemElement itemElement119 = new MenuItemElement( "ELEMENT 119", new Label( "LABEL 119" ) );
        item1.addMenuItemElements( itemElement10, itemElement11, itemElement12, itemElement13, itemElement14,
                                   itemElement15, itemElement16, itemElement17, itemElement18, itemElement19,
                                   itemElement110, itemElement111, itemElement112, itemElement113, itemElement114,
                                   itemElement115, itemElement116, itemElement117, itemElement118, itemElement119 );
        itemElement12.setMenuItemElementDraggable( false );
        menu.addMenuItem( item1 );

        MenuItem item2 = new MenuItem( "TAB 2 (testing)" );
        MenuItemElement itemElement21 = new MenuItemElement( "ELEMENT 21", new Label( "LABEL 21" ) );
        MenuItemElement itemElement22 = new MenuItemElement( "ELEMENT 22", new Label( "LABEL 22" ) );
        MenuItemElement itemElement23 = new MenuItemElement( "ELEMENT 23", new Label( "LABEL 23" ) );
        item2.addMenuItemElements( itemElement21, itemElement22, itemElement23 );
        menu.addMenuItem( item2 );

        MenuItem item3 = new MenuItem( "TAB 3 (testing)" );
        ListSelect list = new ListSelect();
        list.addItems( "Mercury 1", "Venus 1", "Earth 1", "Dušan 1", "Andreja 1" );
        list.setNullSelectionAllowed( false );
        list.setRows( 5 );
        list.setSizeFull();
        ComboBox combo = new ComboBox();
        combo.addItems( "Mercury 2 ", "Venus 2", "Earth 2", "Dušan 2", "Andreja 2" );
        combo.setNullSelectionAllowed( false );
        combo.setValue( "Mercury 2" );
        combo.setSizeUndefined();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent( combo );
        verticalLayout.addComponent( list );
        MenuItemElement itemElement31 = new MenuItemElement( "ELEMENT 31", new Label( "LABEL 31" ) );
        MenuItemElement itemElement32 =
            new MenuItemElement( "ELEMENT 32 testing testing testing testing", verticalLayout );
        MenuItemElement itemElement33 = new MenuItemElement( "ELEMENT 33", new Label( "LABEL 33" ) );
        item3.addMenuItemElements( itemElement31, itemElement32, itemElement33 );
        item3.setMenuItemElementsDraggable( true );
        menu.addMenuItem( item3 );

        return menu;
    }

    @WebServlet( urlPatterns = "/*", name = "DMenuUIServlet", asyncSupported = true )
    @VaadinServletConfiguration( ui = DMenuUI.class, productionMode = false )
    public static class DMenuUIServlet
        extends VaadinServlet
    {

        private static final long serialVersionUID = 206821317774642830L;

    }

}
