/**
 * Copyright (C) 2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.elements;

import static com.google.gwt.query.client.GQuery.$;

import org.dussan.vaadin.dmenu.client.VDMenu;

import com.google.gwt.dom.client.Style.Position;
import com.google.gwt.query.client.css.CSS;
import com.google.gwt.query.client.css.Length;
import com.google.gwt.user.client.Window;

public class FloatingMenu {

	private int menuDirection = VDMenu.MENU_DIRECTION_AUTO;
	private int containerHeight = 0;
	private String menuId = null;

	private void minimizeFloatingMenu(boolean minimize) {
		if (minimize) {
			$(VDMenu.ID(menuId)).parent().css(CSS.MARGIN_BOTTOM.getCssName(),
					VDMenu.NO_VALUE);
			$(VDMenu.ID(menuId)).css(CSS.WIDTH.with(Length.pct(100)))
					.css(CSS.TOP.getCssName(), VDMenu.NO_VALUE)
					.css(CSS.BOTTOM.getCssName(), VDMenu.NO_VALUE)
					.find("[class*=' " + VDMenu.CONTAINER + "']")
					.addClass(VDMenu.MINIMIZED);
		} else {
			int height = $(VDMenu.ID(menuId)).outerHeight();
			int width = $(VDMenu.ID(menuId)).parent().width();
			$(VDMenu.ID(menuId)).parent().css(
					CSS.MARGIN_BOTTOM.with(Length.px(height)));
			$(VDMenu.ID(menuId)).css(CSS.WIDTH.with(Length.px(width)))
					.find("[class*=' " + VDMenu.CONTAINER + "']")
					.removeClass(VDMenu.MINIMIZED);
		}
	}

	public void setContainerHeight(int height) {
		this.containerHeight = height;
	}

	public boolean isFloatingMenuEnabled() {
		return (menuId != null);
	}

	public int getMenuDirection() {
		return menuDirection;
	}

	public void setMenuDirection(int menuDirection) {
		this.menuDirection = menuDirection;
	}

	public void enableFloatingMenu(String menuId) {
		minimizeFloatingMenu(true);
		this.menuId = menuId;
	}

	public void disableFloatingMenu() {
		minimizeFloatingMenu(false);
		menuId = null;
	}

	public boolean isFloatingMenuVisible() {
		return (menuId != null && $(VDMenu.ID(menuId)).css(CSS.POSITION)
				.equals(Position.FIXED.getCssName()));
	}

	public void showFloatingMenu(String tabsLocation) {
		if (!isFloatingMenuVisible()) {
			int top = $(VDMenu.ID(menuId)).offset().top;
			int bottom = top + $(VDMenu.ID(menuId)).outerHeight();

			$(VDMenu.ID(menuId)).css(CSS.TOP.getCssName(), VDMenu.NO_VALUE)
					.css(CSS.BOTTOM.getCssName(), VDMenu.NO_VALUE)
					.css(CSS.POSITION.with(Position.FIXED));
			minimizeFloatingMenu(false);

			// check floating menu visibility
			int direction = menuDirection;
			if (menuDirection == VDMenu.MENU_DIRECTION_AUTO) {
				direction = VDMenu.TAB_LOCATION_TOP.equals(tabsLocation) ? VDMenu.MENU_DIRECTION_DOWN
						: VDMenu.MENU_DIRECTION_UP;
				if (VDMenu.TAB_LOCATION_TOP.equals(tabsLocation)
						&& (Window.getScrollTop() + Window.getClientHeight()) < (bottom + containerHeight)) {
					direction = VDMenu.MENU_DIRECTION_UP;
				} else if (VDMenu.TAB_LOCATION_BOTTOM.equals(tabsLocation)
						&& (top - containerHeight) <= Window.getScrollTop()) {
					direction = VDMenu.MENU_DIRECTION_DOWN;
				}
			}

			switch (direction) {
			case VDMenu.MENU_DIRECTION_UP:
				$(VDMenu.ID(menuId)).css(
						CSS.BOTTOM.with(Length.px(Window.getScrollTop()
								+ Window.getClientHeight() - bottom)));
				break;
			case VDMenu.MENU_DIRECTION_DOWN:
			default:
				$(VDMenu.ID(menuId)).css(CSS.TOP.with(Length.px(top)));
				break;
			}
		}
	}

	public void hideFloatingMenu() {
		if (isFloatingMenuVisible()) {
			$(VDMenu.ID(menuId))
					.css(CSS.POSITION.getCssName(), VDMenu.NO_VALUE);
			minimizeFloatingMenu(true);
		}
	}

}
