/**
 * Copyright (C) 2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.elements;

import java.io.Serializable;

import com.vaadin.ui.Component;

public class MenuItemElement implements Serializable {

	private static final long serialVersionUID = 3348957975993086723L;
	private String caption = null;
	private Component content = null;

	public MenuItemElement(String caption) {
		setCaption(caption);
	}

	public MenuItemElement(String caption, Component content) {
		setCaption(caption);
		setContent(content);
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public Component getContent() {
		return content;
	}

	public void setContent(Component content) {
		// reset content height
		content.setHeight(null);
		this.content = content;
	}

}
