/**
 * Copyright (C) 2013-2015  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.test;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.TabsLocation;
import org.dussan.vaadin.dmenu.elements.Menu;
import org.dussan.vaadin.dmenu.elements.MenuItem;
import org.dussan.vaadin.dmenu.elements.MenuItemElement;
import org.dussan.vaadin.dmenu.events.ActiveTabChangeEvent;
import org.dussan.vaadin.dmenu.events.ActiveTabChangeHandler;
import org.dussan.vaadin.dmenu.events.FloatingMenuChangeEvent;
import org.dussan.vaadin.dmenu.events.FloatingMenuChangeHandler;
import org.dussan.vaadin.dmenu.events.FloatingMenuItemChangeEvent;
import org.dussan.vaadin.dmenu.events.FloatingMenuItemChangeHandler;

import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Button;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Notification.Type;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

public class DMenuTestUI extends UI {

	private static final long serialVersionUID = 6619717330269849744L;

	@Override
	protected void init(VaadinRequest request) {
		GridLayout view = new GridLayout(1, 2);
		view.setSizeFull();
		setContent(view);

		MenuItem menuItem1 = new MenuItem("aaaaaa");
		menuItem1.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("11111111111", new Button.ClickListener() {
					private static final long serialVersionUID = 1L;

					@Override
					public void buttonClick(Button.ClickEvent event) {
						Notification.show(event.getButton().getCaption(),
								Type.TRAY_NOTIFICATION);
					}
				})));
		menuItem1.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("2222222222222", new Button.ClickListener() {
					private static final long serialVersionUID = 1L;

					@Override
					public void buttonClick(Button.ClickEvent event) {
						Notification.show(event.getButton().getCaption(),
								Type.TRAY_NOTIFICATION);
					}
				})));

		MenuItem menuItem2 = new MenuItem("111111111");
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("3333333333333")));
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("444444444444444")));
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new VerticalLayout(new Button("55555555555555555"), new Button(
						"666666666666"))));
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("77777")));
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("8888")));
		menuItem2.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new VerticalLayout(new Button("9999999999999999"), new Button(
						"11 11 11"))));
		Menu menu = new Menu();

		MenuItem menuItem3 = new MenuItem("222");
		menuItem3.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("12")));
		menuItem3.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("13")));

		MenuItem menuItem4 = new MenuItem("333333333333333333");
		menuItem4.addMenuElement(new MenuItemElement("ee333 1 3333ee",
				new Button("14")));
		menuItem4.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("15")));

		MenuItem menuItem5 = new MenuItem("44444 444444444");
		menuItem5.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("16")));
		menuItem5.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("17")));

		MenuItem menuItem6 = new MenuItem("5555555555 55555555");
		menuItem6.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("18")));
		menuItem6.addMenuElement(new MenuItemElement("ee333 333333 3333ee",
				new Button("19")));

		menu.addMenuItems(menuItem1, menuItem2, menuItem3, menuItem4,
				menuItem5, menuItem6);

		DMenu dmenu = new DMenu(menu);
		dmenu.enableMenuTabsAutoShow(false);
		dmenu.enableMenuItemTooltip(true);
		dmenu.enableMenuItemAutoShrink(true);
		dmenu.enableFloatingMenuItemAutoShow(false);
		dmenu.enableFloatingElementsAutoHide(false);
		dmenu.setMenuHidden(true);
		dmenu.setTabsLocation(TabsLocation.TOP_RIGHT);
		dmenu.setMargins(true);

		dmenu.addHandler(new ActiveTabChangeHandler() {
			@Override
			public void onActiveTabChange(ActiveTabChangeEvent event) {
				// Notification.show("Active tab: " + event.getActiveTab(),
				// Type.TRAY_NOTIFICATION);
			}
		});

		dmenu.addHandler(new FloatingMenuChangeHandler() {
			@Override
			public void onFloatingMenuChange(FloatingMenuChangeEvent event) {
				// Notification.show("Menu visible: " + event.isVisible(),
				// Type.TRAY_NOTIFICATION);
			}
		});

		dmenu.addHandler(new FloatingMenuItemChangeHandler() {
			@Override
			public void onFloatingMenuItemChange(
					FloatingMenuItemChangeEvent event) {
				// Notification.show("Menu item visible: " + event.isVisible(),
				// Type.TRAY_NOTIFICATION);
			}
		});

		view.setRowExpandRatio(0, 1.0f);
		view.addComponent(new Label("Testing..."), 0, 0);
		view.addComponent(dmenu.getComponent(), 0, 1);
	}

}
