/**
 * Copyright (C) 2013-2015  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.connector;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.client.VDMenu;
import org.dussan.vaadin.dmenu.client.events.MenuEvents;
import org.dussan.vaadin.dmenu.client.rpc.MenuServerRpc;
import org.dussan.vaadin.dmenu.client.state.MenuState;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.client.ComponentConnector;
import com.vaadin.client.ConnectorHierarchyChangeEvent;
import com.vaadin.client.LayoutManager;
import com.vaadin.client.communication.RpcProxy;
import com.vaadin.client.communication.StateChangeEvent;
import com.vaadin.client.ui.AbstractComponentContainerConnector;
import com.vaadin.client.ui.layout.ElementResizeEvent;
import com.vaadin.client.ui.layout.ElementResizeListener;
import com.vaadin.shared.ui.Connect;

@Connect(DMenu.MenuComponent.class)
public class MenuConnector extends AbstractComponentContainerConnector
		implements ValueChangeHandler<Object[]> {

	private static final long serialVersionUID = -5835057962150067653L;
	private MenuServerRpc serverRpc = RpcProxy
			.create(MenuServerRpc.class, this);

	@Override
	protected Widget createWidget() {
		return GWT.create(VDMenu.class);
	}

	@Override
	public VDMenu getWidget() {
		return (VDMenu) super.getWidget();
	}

	@Override
	public MenuState getState() {
		return (MenuState) super.getState();
	}

	@Override
	protected void init() {
		super.init();
		LayoutManager.get(getConnection()).addElementResizeListener(
				getWidget().getElement(), new ElementResizeListener() {
					@Override
					public void onElementResize(final ElementResizeEvent event) {
						if (!getWidget().isMenuPrepared()) {
							// don't remove: it defines menu container height
							// getWidget().setHeight(
							// getWidget().getOffsetHeight() + "px");
							getWidget().prepareMenu();
							// // fixing layout size when use hidden floating
							// menu
							// Scheduler.get().scheduleFixedDelay(
							// new RepeatingCommand() {
							// @Override
							// public boolean execute() {
							// event.getLayoutManager()
							// .forceLayout();
							// return false;
							// }
							// }, 10);
						}
					}
				});
		getWidget().addValueChangeHandler(this);
	}

	@Override
	public void updateCaption(ComponentConnector connector) {
		// not used
	}

	@Override
	public void onConnectorHierarchyChange(
			ConnectorHierarchyChangeEvent connectorHierarchyChangeEvent) {
		getWidget().add(getChildComponents().get(0).getWidget());
	}

	@Override
	public void onStateChanged(StateChangeEvent stateChangeEvent) {
		super.onStateChanged(stateChangeEvent);
		getWidget().processMenuActions(getState().getMenuActions());
	}

	@Override
	public void onValueChange(ValueChangeEvent<Object[]> event) {
		switch ((Integer) event.getValue()[0]) {
		case MenuEvents.ACTIONS_ARE_PROCESSED:
			serverRpc.onActionsAreProcessed();
			break;
		case MenuEvents.ACTIVE_TAB_EVENT:
			serverRpc.onActiveTabValueChange((Integer) event.getValue()[1]);
			break;
		case MenuEvents.FLOATING_MENU_EVENT:
			serverRpc.onFloatingMenuValueChange((Boolean) event.getValue()[1]);
			break;
		case MenuEvents.FLOATING_ITEM_EVENT:
			serverRpc.onFloatingItemValueChange((Boolean) event.getValue()[1]);
			break;
		default:
			break;
		}
	}

}
