/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu;

import org.dussan.vaadin.dmenu.menuitem.CaptionLocation;
import org.dussan.vaadin.dmenu.menuitem.MenuItem;
import org.dussan.vaadin.dmenu.menuitem.MenuItemElement;
import org.junit.Assert;
import org.junit.Test;

import com.vaadin.ui.Label;

public class DMenuTest
{

    @Test
    public void basicTest()
    {
        DMenu menu = new DMenu();

        menu.setTabBarBottom( true );
        Assert.assertTrue( menu.isTabBarBottom() );

        menu.setMenuTabsAutoChange( true );
        Assert.assertTrue( menu.isMenuTabsAutoChange() );

        menu.setFloatingMenu( true );
        Assert.assertTrue( menu.isFloatingMenu() );

        menu.setFloatingMenuItemAutoHide( true );
        Assert.assertTrue( menu.isFloatingMenuItemAutoHide() );

        menu.setFloatingMenuItemAutoShow( true );
        Assert.assertTrue( menu.isFloatingMenuItemAutoShow() );

        menu.setMenuItemsSameHeight( true );
        Assert.assertTrue( menu.isMenuItemsSameHeight() );

        menu.setMenuItemElementsSameHeight( true );
        Assert.assertTrue( menu.isMenuItemElementsSameHeight() );

        MenuItem item1 = new MenuItem( "TAB 1" );
        MenuItemElement itemElement1 = new MenuItemElement( "ELEMENT 1", new Label( "LABEL 1" ) );
        item1.addMenuItemElement( itemElement1 );
        Assert.assertEquals( new String( "TAB 1" ), item1.getCaption() );
        Assert.assertEquals( new String( "ELEMENT 1" ), itemElement1.getCaption() );
        Assert.assertEquals( 1, item1.getMenuItemElements()
                                     .size() );

        item1.setMenuItemElementsCaptionLocation( CaptionLocation.TOP );
        Assert.assertEquals( CaptionLocation.TOP, item1.getMenuItemElementsCaptionLocation() );

        menu.addMenuItem( item1 );
        Assert.assertEquals( 1, menu.getMenuItems()
                                    .size() );

        MenuItem item2 = new MenuItem( "TAB 2" );
        MenuItemElement itemElement2 = new MenuItemElement( "ELEMENT 2", new Label( "LABEL 2" ) );
        item2.addMenuItemElement( itemElement2 );
        menu.addMenuItem( item2, 0 );
        Assert.assertEquals( item2, menu.getMenuItem( 0 ) );
    }

    @Test
    public void componentViewState()
    {
        MenuItemElement itemElement = new MenuItemElement( "ELEMENT 1", new Label( "LABEL 1" ) );

        itemElement.setEnabled( false );
        Assert.assertFalse( itemElement.isEnabled() );

        itemElement.setReadOnly( true );
        Assert.assertTrue( itemElement.isReadOnly() );

        itemElement.setVisible( false );
        Assert.assertFalse( itemElement.isVisible() );
    }

}
