/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.connector;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.client.VDMenu;
import org.dussan.vaadin.dmenu.client.events.MenuEvents;
import org.dussan.vaadin.dmenu.client.rpc.MenuServerRpc;
import org.dussan.vaadin.dmenu.client.state.MenuState;
import org.dussan.vaadin.dtabs.client.TabsConnector;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.vaadin.client.communication.RpcProxy;
import com.vaadin.client.communication.StateChangeEvent;
import com.vaadin.client.ui.SimpleManagedLayout;
import com.vaadin.shared.ui.Connect;

@Connect( DMenu.class )
public class MenuConnector
    extends TabsConnector
    implements SimpleManagedLayout, ValueChangeHandler<Object[]>
{

    private static final long serialVersionUID = -5835057962150067653L;

    private MenuServerRpc serverRpc = null;

    public MenuConnector()
    {
        serverRpc = RpcProxy.create( MenuServerRpc.class, this );
    }

    @Override
    protected void init()
    {
        super.init();
        getWidget().addValueChangeHandler( this );
    }

    @Override
    public MenuState getState()
    {
        return (MenuState) super.getState();
    }

    @Override
    public VDMenu getWidget()
    {
        return (VDMenu) super.getWidget();
    }

    @Override
    public void onStateChanged( StateChangeEvent stateChangeEvent )
    {
        super.onStateChanged( stateChangeEvent );
        getWidget().setConnection( getConnection() );
        getWidget().setMenuId( getState().getMenuId() );
        getWidget().setSelectedMenuItem( getState().getSelectedMenuItem() );
        getWidget().setMenuItemElementsCount( getState().getMenuItemElementsCount() );
        getWidget().setMenuItemsSameHeight( getState().isMenuItemsSameHeight() );
        getWidget().setMenuItemsSameHeightDefined( getState().isMenuItemsSameHeightDefined() );
        getWidget().setMenuItemElementsSameHeight( getState().isMenuItemElementsSameHeight() );
        getWidget().setMenuItemAutoChange( getState().isMenuItemAutoChange() );
        getWidget().setFloatingMenu( getState().isFloatingMenu() );
        getWidget().setFloatingMenuLock( getState().isFloatingMenuLock() );
        getWidget().setFloatingMenuItemAutoHide( getState().isFloatingMenuItemAutoHide() );
        getWidget().setFloatingMenuItemAutoShow( getState().isFloatingMenuItemAutoShow() );
        getWidget().resetHiddenMenuItemElements();
    }

    @Override
    public void layout()
    {
        super.layout();
        getWidget().setMenuItemAutoChange();
        getWidget().setMenuItemsSameHeight();
        if ( !getWidget().isMenuItemsSameHeightDefined() )
        {
            getWidget().setMenuItemElementsSameHeight();
        }
        getWidget().checkMenuItemElementsVisibility( true );
        getWidget().setFloatingMenu();
    }

    @Override
    public void onValueChange( ValueChangeEvent<Object[]> event )
    {
        switch ( (Integer) event.getValue()[0] )
        {
            case MenuEvents.FLOATING_MENU_ITEM_CHANGE:
                serverRpc.floatingMenuItemChange( (String) event.getValue()[1] );
                break;
            case MenuEvents.FLOATING_MENU_ITEM_SHOW:
                serverRpc.floatingMenuItemShow( (Boolean) event.getValue()[1] );
                break;
            case MenuEvents.FLOATING_MENU_LOCKED:
                serverRpc.floatingMenuLocked( (Boolean) event.getValue()[1] );
                break;
            case MenuEvents.MENU_ITEM_CHANGE:
                serverRpc.menuItemChange( (String) event.getValue()[1] );
                break;
            case MenuEvents.MENU_ITEM_ELEMENT_CLICK:
                serverRpc.menuItemElementClick( (Integer) event.getValue()[1], (Boolean) event.getValue()[2] );
                break;
            case MenuEvents.MOVE_MENU_ITEM_ELEMENTS_TO_ITS_PARENT:
                serverRpc.moveMenuItemElementsToItsParent();
                break;
            default:
                break;
        }
    }

}
