/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.events;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;

public class MenuEvents
{

    public static final String FAILED_TO_FIRE_EVENT_FOR_ACTIVE_TAB = "Failed to fire event for active tab.";

    public static final int FIRST_VISIBLE_MENU_ITEM_ELEMENT_CHANGE = 0;

    public static final int FLOATING_MENU_ITEM_CHANGE = 1;

    public static final int FLOATING_MENU_ITEM_SHOW = 2;

    public static final int FLOATING_MENU_LOCKED = 3;

    public static final int MENU_ITEM_CHANGE = 4;

    public static final int MENU_ITEM_ELEMENT_CLICK = 5;

    public static final int MOVE_MENU_ITEM_ELEMENTS_TO_ITS_PARENT = 6;

    private MenuEvents()
    {
        // Auto-generated constructor stub
    }

    private static <T> void fire( HasValueChangeHandlers<T> source, T value )
    {
        try
        {
            ValueChangeEvent.fire( source, value );
        }
        catch ( IndexOutOfBoundsException e )
        {
            Logger.getGlobal()
                  .log( Level.WARNING, FAILED_TO_FIRE_EVENT_FOR_ACTIVE_TAB );
            throw e;
        }
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireFirstVisibleMenuItemElementChange( HasValueChangeHandlers<T> source,
                                                                  Integer activeMenuItem,
                                                                  Integer firstVisibleMenuItemElement )
    {
        fire( source, (T) new Object[] { FIRST_VISIBLE_MENU_ITEM_ELEMENT_CHANGE, activeMenuItem,
            firstVisibleMenuItemElement } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireFloatingMenuItemChange( HasValueChangeHandlers<T> source, String menuItemId,
                                                       Integer menuPanelMaxHeight )
    {
        fire( source, (T) new Object[] { FLOATING_MENU_ITEM_CHANGE, menuItemId, menuPanelMaxHeight } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireFloatingMenuItemShow( HasValueChangeHandlers<T> source, Boolean floatingMenuItemShow )
    {
        fire( source, (T) new Object[] { FLOATING_MENU_ITEM_SHOW, floatingMenuItemShow } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireFloatingMenuLocked( HasValueChangeHandlers<T> source, Boolean floatingMenuLocked )
    {
        fire( source, (T) new Object[] { FLOATING_MENU_LOCKED, floatingMenuLocked } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMenuItemChange( HasValueChangeHandlers<T> source, String menuActiveTabId,
                                               Integer menuPanelMaxHeight )
    {
        fire( source, (T) new Object[] { MENU_ITEM_CHANGE, menuActiveTabId, menuPanelMaxHeight } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMenuItemElementClick( HasValueChangeHandlers<T> source, Integer menuItemElementId,
                                                     Boolean doubleClick )
    {
        fire( source, (T) new Object[] { MENU_ITEM_ELEMENT_CLICK, menuItemElementId, doubleClick } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMoveMenuItemElementsToItsParent( HasValueChangeHandlers<T> source )
    {
        fire( source, (T) new Object[] { MOVE_MENU_ITEM_ELEMENTS_TO_ITS_PARENT } );
    }

}
