/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.events;

import com.google.gwt.event.shared.GwtEvent;

public class FloatMenuItemLockEvent
    extends GwtEvent<FloatMenuItemLockHandler>
{

    public static final Type<FloatMenuItemLockHandler> TYPE = new Type<>();

    private boolean locked = false;

    public FloatMenuItemLockEvent( boolean locked )
    {
        this.locked = locked;
    }

    public boolean isLocked()
    {
        return locked;
    }

    @Override
    public Type<FloatMenuItemLockHandler> getAssociatedType()
    {
        return TYPE;
    }

    @Override
    protected void dispatch( FloatMenuItemLockHandler handler )
    {
        handler.onFloatMenuItemLock( this );
    }

    public static Type<FloatMenuItemLockHandler> getType()
    {
        return TYPE;
    }

}
