/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.menuitem;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.vaadin.ui.Component;

public class ComponentViewState
    implements Serializable
{

    private static final long serialVersionUID = -4975093730400730785L;

    private transient Map<Integer, Boolean> enabled = null;

    private transient Map<Integer, Boolean> readOnly = null;

    private transient Map<Integer, Boolean> visible = null;

    public ComponentViewState()
    {
        enabled = new HashMap<>();
        readOnly = new HashMap<>();
        visible = new HashMap<>();
    }

    public void setEnabled( Component component, Boolean enabled )
    {
        if ( component != null )
        {
            int hashCode = component.hashCode();
            if ( !enabled && !this.enabled.containsKey( hashCode ) )
            {
                this.enabled.put( hashCode, component.isEnabled() );
                component.setEnabled( enabled );
            }
            else if ( !this.enabled.isEmpty() && this.enabled.containsKey( hashCode ) )
            {
                component.setEnabled( this.enabled.get( hashCode ) );
                this.enabled.remove( hashCode );
            }
        }
    }

    public void setReadOnly( Component component, Boolean readOnly )
    {
        if ( component != null )
        {
            int hashCode = component.hashCode();
            if ( readOnly && !this.readOnly.containsKey( hashCode ) )
            {
                this.readOnly.put( hashCode, component.isReadOnly() );
                component.setReadOnly( readOnly );
            }
            else if ( !this.readOnly.isEmpty() && this.readOnly.containsKey( hashCode ) )
            {
                component.setReadOnly( this.readOnly.get( hashCode ) );
                this.readOnly.remove( hashCode );
            }
        }
    }

    public void setVisible( Component component, Boolean visible )
    {
        if ( component != null )
        {
            int hashCode = component.hashCode();
            if ( !visible && !this.visible.containsKey( hashCode ) )
            {
                this.visible.put( hashCode, component.isVisible() );
                component.setVisible( visible );
            }
            else if ( !this.visible.isEmpty() && this.visible.containsKey( hashCode ) )
            {
                component.setVisible( this.visible.get( hashCode ) );
                this.visible.remove( hashCode );
            }
        }
    }

}
