/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.test;

import javax.servlet.annotation.WebServlet;

import org.dussan.vaadin.dmenu.DMenu;
import org.dussan.vaadin.dmenu.menuitem.MenuItem;
import org.dussan.vaadin.dmenu.menuitem.MenuItemElement;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptAll;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.DragAndDropWrapper;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;

@Theme( "dmenu-theme" )
@Title( "DMenu Add-on Test" )
@Widgetset( "org.dussan.vaadin.dmenu.WidgetSet" )
public class DMenuUI
    extends UI
{

    private static final long serialVersionUID = 1833595858297782412L;

    private static final String WIDTH_1 = "500px";

    private static final String WIDTH_2 = "400px";

    private static final String HEIGHT = "200px";

    private static final String DEFAULT_STYLE_STRING = "Default style";

    private static final String LARGE_STYLE = "large";

    private static final String LARGE_STYLE_STRING = "Large style";

    private static final String WRAPPING_STYLE = "wrapping";

    private static final int ROWS = 5;

    @Override
    protected void init( VaadinRequest vaadinRequest )
    {
        VerticalLayout view = new VerticalLayout();
        view.setSizeFull();
        view.setHeightUndefined();
        setContent( view );

        DMenu menu = new DMenu();
        menu.setTabBarBottom( false )
            .setCenteredTabs( true );
        menu.setMenuTabsAutoChange( false );
        menu.setFloatingMenu( false );
        menu.setFloatingMenuItemAutoHide( false );
        menu.setFloatingMenuItemAutoShow( false );
        menu.setMenuItemsSameHeight( true );
        menu.setMenuItemElementsSameHeight( true );

        Table table = new Table();
        table.setSizeFull();
        table.setPageLength( 3 );
        table.addContainerProperty( "COL1", String.class, null );
        table.addContainerProperty( "COL2", String.class, null );
        table.addContainerProperty( "COL3", String.class, null );
        table.addContainerProperty( "COL4", String.class, null );
        table.addItem( new Object[] { "1", "1", "1", "1" }, null );
        table.addItem( new Object[] { "2", "2", "2", "2" }, null );
        table.addItem( new Object[] { "3", "3", "3", "3" }, null );
        table.addItem( new Object[] { "4", "4", "4", "4" }, null );
        table.addItem( new Object[] { "5", "5", "5", "5" }, null );

        MenuItem item1 = new MenuItem( "TAB 1" );
        MenuItemElement itemElement10 = new MenuItemElement( null, table );
        MenuItemElement itemElement11 = new MenuItemElement( "ELEMENT 11", new Label( "LABEL 11" ) );
        MenuItemElement itemElement12 = new MenuItemElement( "ELEMENT 12", new Label( "LABEL 12" ) );
        MenuItemElement itemElement13 = new MenuItemElement( "ELEMENT 13", new Label( "LABEL 13" ) );
        OptionGroup group = new OptionGroup();
        group.addItem( "One" );
        group.addItem( "Two" );
        group.addItem( "Three" );
        group.setItemEnabled( "Two", false );
        MenuItemElement itemElement14 = new MenuItemElement( "ELEMENT 14", group );
        MenuItemElement itemElement15 = new MenuItemElement( "ELEMENT 15", new Label( "LABEL 15" ) );
        MenuItemElement itemElement16 = new MenuItemElement( "ELEMENT 16", new Label( "LABEL 16" ) );
        MenuItemElement itemElement17 = new MenuItemElement( "ELEMENT 17", new Label( "LABEL 17" ) );
        MenuItemElement itemElement18 = new MenuItemElement( "ELEMENT 18", new Label( "LABEL 18" ) );
        item1.addMenuItemElements( itemElement10, itemElement11, itemElement12, itemElement13, itemElement14,
                                   itemElement15, itemElement16, itemElement17, itemElement18 );
        itemElement12.setMenuItemElementDraggable( false );
        menu.addMenuItem( item1 );

        MenuItem item2 = new MenuItem( "TAB 2" );
        MenuItemElement itemElement21 = new MenuItemElement( "ELEMENT 21", new Label( "LABEL 21" ) );
        MenuItemElement itemElement22 = new MenuItemElement( "ELEMENT 22", new Label( "LABEL 22" ) );
        MenuItemElement itemElement23 = new MenuItemElement( "ELEMENT 23", new Label( "LABEL 23" ) );
        item2.addMenuItemElements( itemElement21, itemElement22, itemElement23 );
        menu.addMenuItem( item2 );

        MenuItem item3 = new MenuItem( "TAB 3" );
        ListSelect list = new ListSelect();
        list.addItems( "Mercury 1", "Venus 1", "Earth 1", "Dušan 1", "Andreja 1" );
        list.setNullSelectionAllowed( false );
        list.setRows( ROWS );
        list.setSizeFull();
        ComboBox combo = new ComboBox();
        combo.addItems( "Mercury 2 ", "Venus 2", "Earth 2", "Dušan 2", "Andreja 2" );
        combo.setNullSelectionAllowed( false );
        combo.setValue( "Mercury 2" );
        combo.setSizeUndefined();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent( combo );
        verticalLayout.addComponent( list );
        MenuItemElement itemElement31 = new MenuItemElement( "ELEMENT 31", new Label( "LABEL 31" ) );
        MenuItemElement itemElement32 =
            new MenuItemElement( "ELEMENT 32 testing testing testing testing", verticalLayout );
        MenuItemElement itemElement33 = new MenuItemElement( "ELEMENT 33", new Label( "LABEL 33" ) );
        item3.addMenuItemElements( itemElement31, itemElement32, itemElement33 );
        item3.setMenuItemElementsDraggable( true );
        menu.addMenuItem( item3 );

        HorizontalLayout row = new HorizontalLayout();
        row.addStyleName( WRAPPING_STYLE );
        row.setSpacing( true );
        row.setMargin( new MarginInfo( true, false, false, false ) );
        view.addComponent( row );

        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setCaption( DEFAULT_STYLE_STRING );
        sp.setWidth( WIDTH_2 );
        sp.setHeight( null );
        sp.setFirstComponent( getContext() );
        sp.setSecondComponent( getContext() );
        DragAndDropWrapper spDropWrapper = new DragAndDropWrapper( sp );
        spDropWrapper.setDropHandler( new DropHandler()
        {

            private static final long serialVersionUID = 8356967464135167996L;

            @Override
            public AcceptCriterion getAcceptCriterion()
            {
                return AcceptAll.get();
            }

            @Override
            public void drop( DragAndDropEvent event )
            {
            }
        } );
        row.addComponent( spDropWrapper );

        VerticalSplitPanel sp2 = new VerticalSplitPanel();
        sp2.setCaption( DEFAULT_STYLE_STRING );
        sp2.setWidth( WIDTH_1 );
        sp2.setHeight( HEIGHT );
        sp2.setFirstComponent( getContext() );
        sp2.setSecondComponent( getContext() );
        row.addComponent( sp2 );

        row.addComponent( menu );
        menu.setWidth( WIDTH_1 );

        ListSelect list1 = new ListSelect();
        list1.addItems( "Mercury 1", "Venus 1", "Earth 1", "Dušan 1", "Andreja 1" );
        list1.setNullSelectionAllowed( false );
        list1.setRows( ROWS );
        row.addComponent( list1 );

        sp = new HorizontalSplitPanel();
        sp.setCaption( LARGE_STYLE_STRING );
        sp.setWidth( WIDTH_1 );
        sp.setHeight( HEIGHT );
        sp.addStyleName( LARGE_STYLE );
        sp.setFirstComponent( getContext() );
        sp.setSecondComponent( getContext() );
        row.addComponent( sp );

        sp2 = new VerticalSplitPanel();
        sp2.setCaption( LARGE_STYLE_STRING );
        sp2.setWidth( WIDTH_1 );
        sp2.setHeight( HEIGHT );
        sp2.addStyleName( LARGE_STYLE );
        sp2.setFirstComponent( getContext() );
        sp2.setSecondComponent( getContext() );
        row.addComponent( sp2 );
    }

    public VerticalLayout getContext()
    {
        VerticalLayout contextLayout = new VerticalLayout();
        contextLayout.setMargin( true );
        contextLayout.addComponent( new Label( "Fictum, deserunt mollit anim laborum astutumque!" ) );
        return contextLayout;
    }

    @WebServlet( urlPatterns = "/*", name = "DMenuUIServlet", asyncSupported = true )
    @VaadinServletConfiguration( ui = DMenuUI.class, productionMode = false )
    public static class DMenuUIServlet
        extends VaadinServlet
    {

        private static final long serialVersionUID = 206821317774642830L;

    }

}
