/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.events;

import org.dussan.vaadin.dmenu.menuitem.MenuItemElement;

import com.google.gwt.event.shared.GwtEvent;

public class MenuItemElementClickEvent
    extends GwtEvent<MenuItemElementClickHandler>
{

    public static final Type<MenuItemElementClickHandler> TYPE = new Type<MenuItemElementClickHandler>();

    private boolean doubleClick = false;

    private MenuItemElement menuItemElement = null;

    public MenuItemElementClickEvent( MenuItemElement menuItemElement, boolean doubleClick )
    {
        this.menuItemElement = menuItemElement;
        this.doubleClick = doubleClick;
    }

    public boolean isDoubleClick()
    {
        return doubleClick;
    }

    public MenuItemElement getMenuItemElement()
    {
        return menuItemElement;
    }

    @Override
    public Type<MenuItemElementClickHandler> getAssociatedType()
    {
        return TYPE;
    }

    @Override
    protected void dispatch( MenuItemElementClickHandler handler )
    {
        handler.onMenuItemElementClick( this );
    }

    public static Type<MenuItemElementClickHandler> getType()
    {
        return TYPE;
    }

}
