/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dmenu.client.events;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;

public class MenuEvents
{

    public static final int MOVE_MENU_ITEM_ELEMENTS_TO_ITS_PARENT = 0;

    public static final int MENU_ACTIVE_TAB_CHANGE = 1;

    public static final int MENU_ITEM_SHOW = 2;

    private MenuEvents()
    {
        // Auto-generated constructor stub
    }

    private static <T> void fire( HasValueChangeHandlers<T> source, T value )
    {
        try
        {
            ValueChangeEvent.fire( source, value );
        }
        catch ( IndexOutOfBoundsException e )
        {
            Logger.getGlobal()
                  .log( Level.WARNING, "Failed to fire event for active tab." );
            throw e;
        }
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMoveMenuItemElementsToItsParent( HasValueChangeHandlers<T> source )
    {
        fire( source, (T) new Object[] { MOVE_MENU_ITEM_ELEMENTS_TO_ITS_PARENT } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMenuActiveTabChange( HasValueChangeHandlers<T> source, String menuActiveTabId )
    {
        fire( source, (T) new Object[] { MENU_ACTIVE_TAB_CHANGE, menuActiveTabId } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireMenuItemShow( HasValueChangeHandlers<T> source, String menuItemId )
    {
        fire( source, (T) new Object[] { MENU_ITEM_SHOW, menuItemId } );
    }

}
