/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.test;

import javax.servlet.annotation.WebServlet;

import org.dussan.vaadin.dquery.DQuery;
import org.dussan.vaadin.dquery.enums.SqlDriver;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

@Theme( "dquery-theme" )
@Widgetset( "org.dussan.vaadin.dquery.WidgetSet" )
public class DQueryUI
    extends UI
{

    private static final long serialVersionUID = 5696542465716721125L;

    private static final String DATASOURCE_1 = "test1";

    private static final String DATASOURCE_2 = "test2";

    private static final String DESCRIPITON_1 = "Data for testing";

    private static final String DESCRIPITON_2 = "Testing data";

    private static final String PASSWORD = "test";

    private static final SqlDriver SQL_DRIVER = SqlDriver.MYSQL;

    private static final String URL = "jdbc:mysql://datacenter:3306/test";

    private static final String USER = "test";

    private DQuery query = null;

    public DQueryUI()
    {
        query = new DQuery()
        {
            private static final long serialVersionUID = -6912229424682727493L;

            @Override
            public void saveQuery( String queryGroup, String queryName, String queryString )
            {
                // nothing to do
            }
        };
    }

    @Override
    protected void init( VaadinRequest request )
    {
        query.addDataSource( DATASOURCE_1 )
             .setDescription( DESCRIPITON_1 )
             .setDriver( SQL_DRIVER )
             .setUrl( URL )
             .setUser( USER )
             .setPassword( PASSWORD );
        query.addDataSource( DATASOURCE_2 )
             .setDescription( DESCRIPITON_2 )
             .setDriver( SQL_DRIVER )
             .setUrl( URL )
             .setUser( USER )
             .setPassword( PASSWORD );
        query.setDataSourcesItemVisible( false );
        // query.setCreateNewQueryGroupEnabled( false );
        // query.setDataSourceEnabled( DATASOURCE_2, false );
        // query.setDataSourceTableDisabled( DATASOURCE_1, "dept_emp", false );

        VerticalLayout content = new VerticalLayout();
        content.setSizeFull();
        content.addComponent( query.getContext() );
        setContent( content );
    }

    @WebServlet( urlPatterns = "/*", name = "DQueryUIServlet", asyncSupported = true )
    @VaadinServletConfiguration( ui = DQueryUI.class, productionMode = false )
    public static class DQueryUIServlet
        extends VaadinServlet
    {

        private static final long serialVersionUID = 8594659431268563118L;

    }

}
