/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.sql.functions;

import java.util.HashMap;

import org.dussan.vaadin.dquery.base.sql.functions.SqlFunctions;
import org.dussan.vaadin.dquery.enums.SqlFunctionType;

public class TotalFunctions
    extends SqlFunctions
{

    private static final long serialVersionUID = -6938546053688134897L;

    private static final String AVG = "AVG";

    private static final String AVG_DESCRIPTION = "Returns the average value";

    private static final String COUNT = "COUNT";

    private static final String COUNT_DESCRIPTION = "Returns the number of rows";

    private static final String FIRST = "FIRST";

    private static final String FIRST_DESCRIPTION = "Returns the first value";

    private static final String GROUP_BY = "GROUP BY";

    private static final String GROUP_BY_DESCRIPTION = "Used to group the result set";

    private static final String LAST = "LAST";

    private static final String LAST_DESCRIPTION = "Returns the last value";

    private static final String MAX = "MAX";

    private static final String MAX_DESCRIPTION = "Returns the largest value";

    private static final String MIN = "MIN";

    private static final String MIN_DESCRIPTION = "Returns the smallest value";

    private static final String SUM = "SUM";

    private static final String SUM_DESCRIPTION = "Returns the total sum of a numeric column";

    /**
     * Creates a new instance.
     */
    public TotalFunctions()
    {
        // Total function: AVG
        addFunction( AVG, AVG_DESCRIPTION );

        // Total function: COUNT
        addFunction( COUNT, COUNT_DESCRIPTION );

        // Total function: FIRST
        addFunction( FIRST, FIRST_DESCRIPTION );

        // Total function: GROUP_BY
        addFunction( GROUP_BY, GROUP_BY_DESCRIPTION );
        setType( GROUP_BY, SqlFunctionType.NULL );

        // Total function: LAST
        addFunction( LAST, LAST_DESCRIPTION );

        // Total function: MAX
        addFunction( MAX, MAX_DESCRIPTION );

        // Total function: MIN
        addFunction( MIN, MIN_DESCRIPTION );

        // Total function: SUM
        addFunction( SUM, SUM_DESCRIPTION );
    }

    /**
     * Create cloned instance.
     */
    public TotalFunctions clone()
    {
        TotalFunctions clonedFunctions = new TotalFunctions();
        clonedFunctions.functions = new HashMap<>( functions );
        clonedFunctions.parameterValues = new HashMap<>( parameterValues );
        clonedFunctions.parameters = new HashMap<>( parameters );
        clonedFunctions.types = new HashMap<>( types );
        return clonedFunctions;
    }

}
