/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.sql.functions;

import java.util.HashMap;

import org.dussan.vaadin.dquery.base.sql.functions.SqlFunctions;
import org.dussan.vaadin.dquery.enums.SqlFunctionType;

public class CommonFunctions
    extends SqlFunctions
{

    private static final long serialVersionUID = -5580152946639693606L;

    private static final String ABS = "ABS";

    private static final String ABS_DESCRIPTION = "Returns the absolute value of numeric expression";

    private static final String CEILING = "CEILING";

    private static final String CEILING_DESCRIPTION =
        "Returns the smallest integer value that is not less than passed numeric expression";

    private static final String COALESCE = "COALESCE";

    private static final String COALESCE_DESCRIPTION =
        "Returns a non-null value</br><b>Example usage:</b> COALESCE( 0 )";

    private static final int COALESCE_VALUES = 0;

    private static final String COALESCE_PARAMETER = "default";

    private static final String FLOOR = "FLOOR";

    private static final String FLOOR_DESCRIPTION =
        "Returns the largest integer value that is not greater than passed numeric expression";

    private static final String FORMAT = "FORMAT";

    private static final String FORMAT_DESCRIPTION =
        "This function is used to format how a field is to be displayed</br>"
            + "<b>Example usage for number:</b> FORMAT( \"#,###.##\" )</br>"
            + "<b>Example usage for date:</b> FORMAT( \"YYYY-MM-DD\" )";

    private static final String FORMAT_PARAMETER = "format";

    private static final String LCASE = "LCASE";

    private static final String LCASE_DESCRIPTION = "Returns the string value in lowercase";

    private static final String LEFT = "LEFT";

    private static final String LEFT_DESCRIPTION =
        "Returns the leftmost number of characters as specified</br><b>Example usage:</b> LEFT( 4 )";

    private static final int LEFT_VALUES = 1;

    private static final String LEFT_PARAMETER = "length";

    private static final String LEN = "LEN";

    private static final String LEN_DESCRIPTION = "Returns the length of the value in a text field";

    private static final String MID = "MID";

    private static final String MID_DESCRIPTION =
        "Returns a substring starting from the specified position</br><b>Function parameters:</b></br>"
            + "start (Required): specifies the starting position (starts at 1)</br>"
            + "length (Optional): the number of characters to return; if omitted, the function returns the rest of the text</br>"
            + "<b>Example usage:</b> MID( 2, 3 )";

    private static final String[] MID_PARAMETERS = new String[] { "start", "length" };

    private static final Object[] MID_VALUES = new Object[] { 1, null };

    private static final String NOW = "NOW";

    private static final String NOW_DESCRIPTION = "Returns the current system date and time";

    private static final String RAND = "RAND";

    private static final String RAND_DESCRIPTION = "Returns a random fractional number between 0 and 1";

    private static final String RIGHT = "RIGHT";

    private static final String RIGHT_DESCRIPTION =
        "Returns the specified rightmost number of characters</br><b>Example usage:</b> RIGHT( 4 )";

    private static final int RIGHT_VALUES = 1;

    private static final String RIGHT_PARAMETER = "length";

    private static final String ROUND = "ROUND";

    private static final String ROUND_DESCRIPTION =
        "Returns numeric expression rounded to a number of decimal points</br><b>Example usage:</b> ROUND( 2 )";

    private static final int ROUND_VALUES = 1;

    private static final String ROUND_PARAMETER = "decimals";

    private static final String POWER = "POWER";

    private static final String POWER_DESCRIPTION =
        "Returns the value of one expression raised to the power of another expression</br><b>Example usage:</b> POWER( 2 )";

    private static final int POWER_VALUES = 2;

    private static final String POWER_PARAMETER = "power";

    private static final String SQRT = "SQRT";

    private static final String SQRT_DESCRIPTION = "Returns the non-negative square root of numeric expression";

    private static final String UCASE = "UCASE";

    private static final String UCASE_DESCRIPTION = "Returns the string value in uppercase";

    /**
     * Creates a new instance.
     */
    public CommonFunctions()
    {
        // Common function: ABS
        addFunction( ABS, ABS_DESCRIPTION );

        // Common function: CEILING
        addFunction( CEILING, CEILING_DESCRIPTION );

        // Common function: COALESCE
        addFunction( COALESCE, COALESCE_DESCRIPTION );
        setParameterValues( COALESCE, COALESCE_VALUES );
        setParameters( COALESCE, COALESCE_PARAMETER );

        // Common function: FLOOR
        addFunction( FLOOR, FLOOR_DESCRIPTION );

        // Common function: FORMAT
        addFunction( FORMAT, FORMAT_DESCRIPTION );
        setParameters( FORMAT, FORMAT_PARAMETER );

        // Common function: LCASE
        addFunction( LCASE, LCASE_DESCRIPTION );

        // Common function: LEFT
        addFunction( LEFT, LEFT_DESCRIPTION );
        setParameterValues( LEFT, LEFT_VALUES );
        setParameters( LEFT, LEFT_PARAMETER );

        // Common function: LEN
        addFunction( LEN, LEN_DESCRIPTION );

        // Common function: MID
        addFunction( MID, MID_DESCRIPTION );
        setParameterValues( MID, MID_VALUES );
        setParameters( MID, MID_PARAMETERS );

        // Common function: NOW
        addFunction( NOW, NOW_DESCRIPTION );
        setType( NOW, SqlFunctionType.WITHOUT_PARAMETERS );

        // Common function: RAND
        addFunction( RAND, RAND_DESCRIPTION );
        setType( RAND, SqlFunctionType.WITHOUT_PARAMETERS );

        // Common function: RIGHT
        addFunction( RIGHT, RIGHT_DESCRIPTION );
        setParameterValues( RIGHT, RIGHT_VALUES );
        setParameters( RIGHT, RIGHT_PARAMETER );

        // Common function: ROUND
        addFunction( ROUND, ROUND_DESCRIPTION );
        setParameterValues( ROUND, ROUND_VALUES );
        setParameters( ROUND, ROUND_PARAMETER );

        // Common function: POWER
        addFunction( POWER, POWER_DESCRIPTION );
        setParameterValues( POWER, POWER_VALUES );
        setParameters( POWER, POWER_PARAMETER );

        // Common function: SQRT
        addFunction( SQRT, SQRT_DESCRIPTION );

        // Common function: UCASE
        addFunction( UCASE, UCASE_DESCRIPTION );
    }

    /**
     * Create cloned instance.
     */
    public CommonFunctions clone()
    {
        CommonFunctions clonedFunctions = new CommonFunctions();
        clonedFunctions.functions = new HashMap<>( functions );
        clonedFunctions.parameterValues = new HashMap<>( parameterValues );
        clonedFunctions.parameters = new HashMap<>( parameters );
        clonedFunctions.types = new HashMap<>( types );
        return clonedFunctions;
    }

}
