/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

import org.dussan.vaadin.dquery.utils.StringUtil;

/**
 * SQL drivers.
 */
public enum SqlDriver
{

    Derby( "org_apache_derby_jdbc_ClientDriver" ),
    Derby_embedded( "org_apache_derby_jdbc_EmbeddedDriver" ),
    H2( "org_h2_Driver" ),
    HSQLDB( "org_hsqldb_jdbcDriver" ),
    MySQL( "com_mysql_jdbc_Driver" ),
    PostgreSQL( "org_postgresql_Driver" ),
    SQLite( "org_sqlite_JDBC" );

    private final String driver;

    /**
     * Create a new instance.
     * 
     * @param driver
     *            sql driver
     */
    private SqlDriver( String driver )
    {
        this.driver = driver;
    }

    /**
     * Get sql driver string.
     */
    @Override
    public String toString()
    {
        return driver.replaceAll( StringUtil.UNDERSCORE_VALUE, StringUtil.DOT_VALUE );
    }

}
