/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.utils;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.dussan.vaadin.dquery.DQuery;
import org.dussan.vaadin.dquery.enums.SqlDriver;

public class JdbcUtil
    implements Serializable
{

    private static final long serialVersionUID = -7126855114873216472L;

    private static final String SQL_STATE = "Sql state: {0}";

    private String description = null;

    private Connection connection = null;

    private SqlDriver driver = null;

    private String customDriver = null;

    private String url = null;

    private String user = null;

    private String password = null;

    public JdbcUtil()
    {
        // Auto-generated constructor stub
    }

    public String getDescription()
    {
        return description;
    }

    public JdbcUtil setDescription( String description )
    {
        this.description = description;
        return this;
    }

    public SqlDriver getDriver()
    {
        return driver;
    }

    public JdbcUtil setDriver( SqlDriver driver )
    {
        this.driver = driver;
        return this;
    }

    public String getCustomDriver()
    {
        return customDriver;
    }

    public void setCustomDriver( String customDriver )
    {
        this.customDriver = customDriver;
    }

    public String getUrl()
    {
        return url;
    }

    public JdbcUtil setUrl( String url )
    {
        this.url = url;
        return this;
    }

    public String getUser()
    {
        return user;
    }

    public JdbcUtil setUser( String user )
    {
        this.user = user;
        return this;
    }

    public String getPassword()
    {
        return password;
    }

    public JdbcUtil setPassword( String password )
    {
        this.password = password;
        return this;
    }

    public Connection getConnection()
    {
        try
        {
            if ( connection == null || connection.isClosed() )
            {
                if ( SharedUtil.isNotNullAndNotEmpty( getCustomDriver() ) )
                {
                    Class.forName( getCustomDriver() )
                         .newInstance();
                }
                else
                {
                    Class.forName( getDriver().toString() )
                         .newInstance();
                }
                connection = DriverManager.getConnection( getUrl(), getUser(), getPassword() );
            }
        }
        catch ( InstantiationException e )
        {
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.SEVERE, e.getMessage() );
        }
        catch ( IllegalAccessException e )
        {
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.SEVERE, e.getMessage() );
        }
        catch ( ClassNotFoundException e )
        {
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.SEVERE, e.getMessage() );
        }
        catch ( SQLException e )
        {
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.INFO, e.getMessage() );
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.INFO, MessageFormat.format( SQL_STATE, e.getSQLState() ) );
        }

        return connection;
    }

    public void close()
    {
        try
        {
            if ( connection != null && !connection.isClosed() )
            {
                connection.close();
            }
        }
        catch ( SQLException e )
        {
            Logger.getLogger( DQuery.class.getName() )
                  .log( Level.INFO, e.getMessage() );
        }
        connection = null;
    }

}
