/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.client.events;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;

public class QueryEvents
{

    private static final String FAILED_TO_FIRE_EVENT = "Failed to fire event for dQuery.";

    public static final int CHANGE_JOINED_TABLES = 1;

    public static final int INIT_PROGRESS = 0;

    public static final int TABLE_MOVED = 2;

    private QueryEvents()
    {
        // Auto-generated constructor stub
    }

    private static <T> void fire( HasValueChangeHandlers<T> source, T value )
    {
        try
        {
            ValueChangeEvent.fire( source, value );
        }
        catch ( IndexOutOfBoundsException e )
        {
            Logger.getGlobal()
                  .log( Level.WARNING, FAILED_TO_FIRE_EVENT );
            throw e;
        }
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireChangeJoinedTables( HasValueChangeHandlers<T> source, Object joinedTablesId,
                                                   Integer joinedFieldsIndex )
    {
        fire( source, (T) new Object[] { CHANGE_JOINED_TABLES, joinedTablesId, joinedFieldsIndex } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireInitProgress( HasValueChangeHandlers<T> source, Integer initProgress )
    {
        fire( source, (T) new Object[] { INIT_PROGRESS, initProgress } );
    }

    @SuppressWarnings( "unchecked" )
    public static <T> void fireTableMoved( HasValueChangeHandlers<T> source, Object movedTableId, Integer left,
                                           Integer top )
    {
        fire( source, (T) new Object[] { TABLE_MOVED, movedTableId, left, top } );
    }

}
