/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.enums;

/**
 * Supported table join types.
 */
public enum TablesJoin
{

    INNER( 0 ), LEFT( 1 ), RIGHT( 2 ), REMOVE( 3 );

    private int join;

    /**
     * Create a new instance.
     * 
     * @param join
     *            join type
     */
    private TablesJoin( int join )
    {
        this.join = join;
    }

    /**
     * Get join type as integer value.
     * 
     * @return join type as integer value
     */
    public int getValue()
    {
        return join;
    }

    /**
     * Retrieve join type from string value.
     * 
     * @param value
     *            value from which retrieve join type
     * @return join type
     */
    public static TablesJoin getJoinFromString( String value )
    {
        for ( TablesJoin tableJoin : TablesJoin.values() )
        {
            if ( tableJoin.toString()
                          .equals( value ) )
            {
                return tableJoin;
            }
        }

        // not found
        return null;
    }

    /**
     * Retrieve join type from string number value.
     * 
     * @param value
     *            value from which retrieve join type
     * @return join type
     */
    public static TablesJoin getJoin( String value )
    {
        int val = Integer.parseInt( value );
        for ( TablesJoin tableJoin : TablesJoin.values() )
        {
            if ( tableJoin.join == val )
            {
                return tableJoin;
            }
        }

        // not found
        return null;
    }

    /**
     * Retrieve join type from integer value.
     * 
     * @param value
     *            value from which retrieve join type
     * @return join type
     */
    public static TablesJoin getJoin( int value )
    {
        for ( TablesJoin tableJoin : TablesJoin.values() )
        {
            if ( tableJoin.join == value )
            {
                return tableJoin;
            }
        }

        // not found
        return null;
    }

}
