/**
 * Copyright (C) 2016  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.events;

import java.util.Map;

import org.dussan.vaadin.dquery.json.JsonQuery;

import com.google.gwt.event.shared.GwtEvent;

public class GroupQueryChangeEvent
    extends GwtEvent<GroupQueryChangeHandler>
{

    public static final Type<GroupQueryChangeHandler> TYPE = new Type<>();

    private String queryGroup = null;

    private String queryName = null;

    private Map<String, JsonQuery> queries = null;

    public GroupQueryChangeEvent( String queryGroup, String queryName, Map<String, JsonQuery> queries )
    {
        this.queryGroup = queryGroup;
        this.queryName = queryName;
        this.queries = queries;
    }

    public String getQueryGroup()
    {
        return queryGroup;
    }

    public String getQueryName()
    {
        return queryName;
    }

    public Map<String, JsonQuery> getQueries()
    {
        return queries;
    }

    @Override
    public Type<GroupQueryChangeHandler> getAssociatedType()
    {
        return TYPE;
    }

    @Override
    protected void dispatch( GroupQueryChangeHandler handler )
    {
        handler.onGroupQueryChange( this );
    }

    public static Type<GroupQueryChangeHandler> getType()
    {
        return TYPE;
    }

}
