/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.sql.functions;

import java.util.HashMap;

import org.dussan.vaadin.dquery.base.sql.functions.SqlFunctions;
import org.dussan.vaadin.dquery.enums.SqlFunctionType;

public class SortingFunctions
    extends SqlFunctions
{

    private static final long serialVersionUID = -1368529356390787230L;

    private static final String ASC = "ASC";

    private static final String ASC_DESCRIPTION = "Sorts the records in ascending order";

    private static final String DESC = "DESC";

    private static final String DESC_DESCRIPTION = "Sorts the records in descending order";

    /**
     * Creates a new instance.
     */
    public SortingFunctions()
    {
        // Sorting function: ASC
        addFunction( ASC, ASC_DESCRIPTION );
        setType( ASC, SqlFunctionType.NULL );

        // Sorting function: DESC
        addFunction( DESC, DESC_DESCRIPTION );
        setType( DESC, SqlFunctionType.NULL );
    }

    /**
     * Create cloned instance.
     */
    public SortingFunctions cloneFunctions()
    {
        SortingFunctions clonedFunctions = new SortingFunctions();
        clonedFunctions.functions = new HashMap<>( functions );
        clonedFunctions.parameterValues = new HashMap<>( parameterValues );
        clonedFunctions.parameters = new HashMap<>( parameters );
        clonedFunctions.types = new HashMap<>( types );
        return clonedFunctions;
    }

}
