/**
 * Copyright (C) 2016-2017  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dquery.base.sql.builder;

import java.io.Serializable;
import java.text.MessageFormat;

public class SqlTable
    implements Serializable
{

    private static final long serialVersionUID = 786022457718278748L;

    private static final String STRING = "{0} AS {1}";

    private String tableName = null;

    private String tableAlias = null;

    /**
     * Creates a new instance.
     */
    public SqlTable()
    {
        // Auto-generated constructor stub
    }

    /**
     * Creates a new instance with table name and table alias.
     */
    public SqlTable( String tableName, String tableAlias )
    {
        setTableName( tableName ).as( tableAlias );
    }

    /**
     * Get table name.
     * 
     * @return table name
     */
    public String getTableName()
    {
        return tableName;
    }

    /**
     * Set table name.
     * 
     * @param tableName
     *            table name
     * @return
     */
    public SqlTable setTableName( String tableName )
    {
        this.tableName = tableName;
        this.tableAlias = tableName;
        return this;
    }

    /**
     * Get table alias.
     * 
     * @return table alias
     */
    public String getTableAlias()
    {
        return tableAlias;
    }

    /**
     * Set table alias.
     * 
     * @param tableAlias
     *            table alias
     */
    public void setTableAlias( String tableAlias )
    {
        this.tableAlias = tableAlias;
    }

    /**
     * Set table alias.
     * 
     * @param tableAlias
     *            table alias
     * @return sql table object
     */
    public SqlTable as( String tableAlias )
    {
        setTableAlias( tableAlias );
        return this;
    }

    /**
     * Get sql string for specified table.
     */
    @Override
    public String toString()
    {
        return MessageFormat.format( STRING, tableName, tableAlias );
    }

}
